package org.dromara.common.core.utils;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class PasswordUtils {

    /**
     * 校验密码复杂度
     */
    public static boolean isValidPassword(String password) {
        if (password == null || password.length() < 8) {
            return false;
        }
        // 至少一个数字
        boolean hasDigit = password.matches(".*\\d.*");
        // 至少一个大写字母
        boolean hasUpper = password.matches(".*[A-Z].*");
        // 至少一个小写字母
        boolean hasLower = password.matches(".*[a-z].*");
        // 至少一个特殊字符（非数字和字母）
        boolean hasSpecial = password.matches(".*[^a-zA-Z0-9].*");

        return hasDigit && hasUpper && hasLower && hasSpecial;
    }
}

