package org.dromara.system.dubbo;

import cn.hutool.core.bean.BeanUtil;
import org.dromara.system.api.RemoteDeptService;
import org.dromara.system.api.domain.bo.RemoteDeptBo;
import org.dromara.system.service.ISysDeptService;
import lombok.RequiredArgsConstructor;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 部门服务
 *
 * @author Lion Li
 */
@RequiredArgsConstructor
@Service
@DubboService
public class RemoteDeptServiceImpl implements RemoteDeptService {

    private final ISysDeptService sysDeptService;

    /**
     * 通过部门ID查询部门名称
     *
     * @param deptIds 部门ID串逗号分隔
     * @return 部门名称串逗号分隔
     */
    @Override
    public String selectDeptNameByIds(String deptIds) {
        return sysDeptService.selectDeptNameByIds(deptIds);
    }

    @Override
    public List<RemoteDeptBo> selectDeptInfo() {
        return BeanUtil.copyToList(sysDeptService.selectDeptInfo(), RemoteDeptBo.class);
    }

    @Override
    public List<RemoteDeptBo> selectDeptInfoByTenantId(String tenantId) {
        return BeanUtil.copyToList(sysDeptService.selectDeptInfoByTenantId(tenantId), RemoteDeptBo.class);
    }
}
