package org.dromara.system.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.dromara.common.core.domain.R;
import org.dromara.system.domain.SysAreas;
import org.dromara.system.domain.SysCities;
import org.dromara.system.domain.SysProvinces;
import org.dromara.system.domain.vo.SysProvinceCAVo;

import java.util.List;
import java.util.Map;

/**
* @author EDY
* @description 针对表【sys_provinces(省份信息表)】的数据库操作Service
* @createDate 2024-11-04 16:20:23
*/
public interface SysProvincesService extends IService<SysProvinces> {

    R<List<SysCities>> getCitiesByProvince(Long provinceId);

    R<List<SysAreas>> getAreasByCity(Long cityId);

    List<SysProvinceCAVo> getProvince();

    Map<String, String> getRegionNames(Long provinceId, Long cityId, Long areaId);
}
