package org.dromara.zjk.controller;

import cn.hutool.core.codec.Base64;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.dromara.common.core.domain.R;
import org.dromara.common.core.utils.DynamicTask;
import org.dromara.zjk.domain.dto.SmsSendDto;
import org.dromara.zjk.domain.dto.SmsUpDto;
import org.dromara.zjk.domain.dto.SmsUpEventDto;
import org.dromara.zjk.domain.dto.SmsUpInfoDto;
import org.dromara.zjk.enums.SmsUpTypeEnum;
import org.dromara.zjk.event.SmsUpEvent;
import org.dromara.zjk.service.ZjkSmsInfoService;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * 短信上行服务
 *
 * @author : yanguohua
 * @version : 1.0
 * @date : 2024/12/24 9:38
 */
@Slf4j
@RestController
@RequestMapping("/sms")
@RequiredArgsConstructor
public class SmsUpController {
    @Resource
    private ZjkSmsInfoService zjkSmsInfoService;
    @Resource
    private DynamicTask dynamicTask;


    private final ApplicationEventPublisher eventPublisher;

    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * http://localhost:8000/dev-api/zjk-api/sms/up
     * @param dto
     * @return
     */
    @PostMapping("/up")
    public String handleUpData(@RequestBody SmsUpDto dto) {
        zjkSmsInfoService.handleUpData(dto);
        return "0";
    }

    @PostMapping("/send")
    public R<Void> sendData(@RequestBody SmsSendDto dto) {
        return zjkSmsInfoService.sendSms(dto);
    }

    @GetMapping("/test")
    public void test() {
        dynamicTask.startDelay("123",()->{
            System.out.println("456");
        },2000);

    }
    @PostMapping("/receive")
    public String receiveUpSms(@RequestParam("deliver") String deliver) {
        try {
            String[] records = deliver.split(";");
            List<SmsUpEventDto> dtoList = new ArrayList<>();

            for (String record : records) {
                String[] parts = record.split("\\|");
                if (parts.length < 5) {
                    log.warn("上行数据格式错误: {}", record);
                    continue;
                }

                String content = new String(Base64.decode(parts[0]), StandardCharsets.UTF_8);
                String code = parts[1];
                String mobile = parts[2];
                String sendTimeStr = parts[3];
                String loginName = parts[4];

                SmsUpEventDto dto = new SmsUpEventDto();
                dto.setContent(content);
                dto.setCode(code);
                dto.setMobile(mobile);
                dto.setSendTime(sdf.parse(sendTimeStr));
                dto.setLoginName(loginName);
                dto.setUpType(SmsUpTypeEnum.ZJSQ.getCode());

                dtoList.add(dto);
            }

            SmsUpInfoDto infoDto = new SmsUpInfoDto();
            infoDto.setInfo(dtoList);

            // 发布事件，交由监听器处理
            eventPublisher.publishEvent(new SmsUpEvent(this, infoDto));

            return "0"; // 必须返回字符串“0”
        } catch (Exception e) {
            log.error("短信上行接收异常", e);
            return "1";
        }
    }
}
