package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import org.dromara.common.mybatis.core.domain.BaseEntity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 积分奖励
 *
 * @TableName zjk_point_reward
 */
@TableName(value = "zjk_point_reward")
@Data
public class ZjkPointReward extends BaseEntity implements Serializable {
    /**
     * 租户号
     */
    @TableId(value = "ID", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 积分奖励名称
     */
    @TableField(value = "reward_name")
    private String rewardName;

    /**
     * 激励类型;字典值reward_type
     */
    @TableField(value = "reward_type")
    private Integer rewardType;

    /**
     * 激励内容
     */
    @TableField(value = "reward_content")
    private String rewardContent;

    /**
     * 激励标的;字典值 积分
     */
    @TableField(value = "reward_obj")
    private Integer rewardObj;

    /**
     * 生效符号;><=
     */
    @TableField(value = "effect_flag")
    private Integer effectFlag;

    /**
     * 生效标准;临界分值
     */
    @TableField(value = "effect_standard")
    private BigDecimal effectStandard;

    /**
     * 激励截至时间
     */
    @TableField(value = "reward_until")
    private Date rewardUntil;

    /**
     * 是否永久;1：永久；0不永久
     */
    @TableField(value = "is_forever")
    private Integer isForever;

    /**
     * 启用标识
     */
    @TableField(value = "status")
    private Integer status;


    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}
