package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import org.dromara.common.sensitive.annotation.Sensitive;
import org.dromara.common.sensitive.core.SensitiveStrategy;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author : yanguohua
 * @version : 1.0
 * @date : 2024/11/8 14:06
 */
@Data
public class PointBaseVO {
    /**
     * id
     */
    private Long expertId;

    /**
     * 姓名
     */
    @ExcelProperty(value = "姓名")
    private String expertName;

    /**
     * 性别
     */
    @ExcelProperty(value = "性别", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "sys_user_sex")
    private Long sex;

    /**
     * 生日
     */
    @ExcelProperty(value = "生日")
    private Date birthDate;


    /**
     * 联系方式
     */
    @ExcelProperty(value = "联系方式")

    @EncryptSensitive
    private String contact;

    /**
     * 工作单位
     */
    @ExcelProperty(value = "工作单位")
    private String workUnit;
    /**
     * 政治面貌
     */
    private String politics;

    /**
     * 职务
     */
    @ExcelProperty(value = "职务")
    private String duty;


    /**
     * 毕业学校
     */
    @ExcelProperty(value = "毕业学校")
    private String graduateSchool;


    /**
     * 邮箱
     */
    @ExcelProperty(value = "邮箱")
    @EncryptSensitive

    private String email;

    /**
     * 专业技术资格
     */
    @ExcelProperty(value = "专业技术资格")
    private String professional;

    /**
     * 专业技术资格取得时间
     */
    @ExcelProperty(value = "专业技术资格取得时间")
    private Date professionalAcquisitionDate;

    /**
     * 从事专业
     */
    @ExcelProperty(value = "从事专业")
    private String workProfessial;

    /**
     * 从事专业年限
     */
    @ExcelProperty(value = "从事专业年限", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "work_professial_year")
    private Integer workProfessialYear;

    /**
     * 照片
     */
    @ExcelProperty(value = "照片")
    private String photograph;

    /**
     * 从事工作或研究领域
     */
    @ExcelProperty(value = "从事工作或研究领域")
    private String performWork;
    /**
     * 从事工作或研究领域
     */
    @ExcelProperty(value = "从事工作或研究领域")
    private String  performWorkId;

    /**
     * 奖励标签
     */
    private List<String> rewardTitle;
    /**
     * 奖励标签
     */
    private Integer rank;
    /**
     * 积分
     */
    private BigDecimal points;
    /**
     * 积分
     */
    private String pointRemark;
    /**
     * 审核状态;1：已审核；2：审核不通过；0：初始不需审核
     */
    private Integer checkStatus;

}
