package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import org.dromara.zjk.domain.ZjkExpert;
import org.dromara.zjk.domain.ZjkProductSummarize;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.domain.ZjkProjectEvaluation;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 项目总结视图对象 zjk_product_summarize
 *
 * @author ygh
 * @date 2024-11-02
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkProductSummarize.class)
public class ZjkProductSummarizeVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    private String search;

    /**
     * id
     */
    @ExcelProperty(value = "id", converter = ExcelDictConvert.class)
    private Long id;

    /**
     * 专家抽取id
     */
    @ExcelProperty(value = "专家抽取id", converter = ExcelDictConvert.class)
    private Long reviewId;

    /**
     * 总结名称
     */
    @ExcelProperty(value = "总结名称", converter = ExcelDictConvert.class)
    private String productSummarizeName;

    /**
     * 总结类型
     */
    @ExcelProperty(value = "总结类型", converter = ExcelDictConvert.class)
    private String productSummarizeType;

    private String productSummarizeTypeName;

    /**
     * 项目概况
     */
    @ExcelProperty(value = "项目概况", converter = ExcelDictConvert.class)
    private String productGeneral;

    /**
     * 评审范围
     */
    @ExcelProperty(value = "评审范围", converter = ExcelDictConvert.class)
    private String reviewScope;

    /**
     * 评审结论
     */
    @ExcelProperty(value = "评审结论", converter = ExcelDictConvert.class)
    private String reviewConclusion;

    /**
     * 反馈
     */
    @ExcelProperty(value = "反馈", converter = ExcelDictConvert.class)
    private String feedback;

    /**
     * 后续改进措施
     */
    @ExcelProperty(value = "后续改进措施", converter = ExcelDictConvert.class)
    private String subsequent;

    /**
     * 附件
     */
    @ExcelProperty(value = "附件", converter = ExcelDictConvert.class)
    @ExcelIgnore
    private String attachment;

    /**
     * 专家id
     */
    @ExcelIgnore
    private String expertIds;

    /**
     * 状态
     */
    @ExcelIgnore
    private String status;
    /**
     * 状态名称
     */
    @ExcelProperty(value = "状态", converter = ExcelDictConvert.class)
    private String statusName;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注", converter = ExcelDictConvert.class)
    private String remark;

    @ExcelProperty(value = "项目时间", converter = ExcelDictConvert.class)
    private Date reviewTime;

    @ExcelIgnore
    private List<ZjkExpertVo> zjkExpertList;
    @ExcelIgnore
    private String productName;

    private Long productId;

    private String reviewSn;

    private Date createTime;

    private ZjkProjectEvaluation zjkProjectEvaluation;
}
