package org.dromara.zjk.expert.expertAwards.domain.bo;

import io.github.linpeilie.annotations.AutoMapper;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.zjk.expert.expertAwards.domain.ZjkExpertAwards;

/**
 * 专家获奖情况业务对象 zjk_expert_awards
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkExpertAwards.class, reverseConvertGenerate = false)
public class ZjkExpertAwardsBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long id;

    /**
     * 专家 id
     */
    @NotNull(message = "专家 id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long expertId;

    /**
     * 获奖证书文件路径
     */
    @NotBlank(message = "获奖证书文件路径不能为空", groups = { AddGroup.class, EditGroup.class })
    private String awardsPath;

    /**
     * 获奖内容
     */
    @NotBlank(message = "获奖内容不能为空", groups = { AddGroup.class, EditGroup.class })
    private String awardsContent;

    private String registrSn;

}
