package org.dromara.zjk.mapper;

import org.dromara.zjk.domain.ZjkCreditReward;
import org.dromara.zjk.domain.vo.ZjkCreditRewardVo;
import org.dromara.common.mybatis.core.mapper.BaseMapperPlus;
import org.dromara.zjk.domain.vo.ZjkCreditRuleVo;
import org.springframework.data.repository.query.Param;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;

/**
 * 信用奖励Mapper接口
 *
 * @author ygh
 * @date 2024-11-11
 */
public interface ZjkCreditRewardMapper extends BaseMapperPlus<ZjkCreditReward, ZjkCreditRewardVo> {

    List<String> getRewardTitle(Long expertId, Long creditCount);

    List<ZjkCreditReward> getAbleReward();

    List<ZjkCreditRuleVo> selectRuleList(@Param("name") String name, @Param("startTime") Date startTime, @Param("endTime") Date endTime);
}
