package org.dromara.zjk.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.ZjkDataChangesLogs;
import org.dromara.zjk.domain.bo.ZjkDataChangesLogsBo;
import org.dromara.zjk.domain.vo.ZjkDataChangesLogsDetailVo;
import org.dromara.zjk.domain.vo.ZjkDataChangesLogsVo;

import java.util.Collection;
import java.util.List;

/**
 * 业务数据变更记录Service接口
 *
 * @author ygh
 * @date 2024-11-07
 */
public interface IZjkDataChangesLogsService {

    /**
     * 查询业务数据变更记录
     *
     * @param id 主键
     * @return 业务数据变更记录
     */
    ZjkDataChangesLogsDetailVo queryById(Long id);

    /**
     * 分页查询业务数据变更记录列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 业务数据变更记录分页列表
     */
    TableDataInfo<ZjkDataChangesLogsVo> queryPageList(ZjkDataChangesLogsBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的业务数据变更记录列表
     *
     * @param bo 查询条件
     * @return 业务数据变更记录列表
     */
    List<ZjkDataChangesLogsVo> queryList(ZjkDataChangesLogsBo bo);

    /**
     * 新增业务数据变更记录
     *
     * @param bo 业务数据变更记录
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkDataChangesLogsBo bo);

    /**
     * 修改业务数据变更记录
     *
     * @param bo 业务数据变更记录
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkDataChangesLogsBo bo);

    /**
     * 校验并批量删除业务数据变更记录信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);


    Boolean insertDataChangesLogs(ZjkDataChangesLogs zjkDataChangesLogs);
}
