package org.dromara.zjk.statement.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;

/**
 * 专家费用报表对象 zjk_money_expert_statement
 *
 * @author ygh
 * @date 2024-12-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_money_expert_statement")
public class ZjkMoneyExpertStatement extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @PropertyMsg(propertyName = "id")
    private Long id;

    /**
     * 专家姓名;专家姓名
     */
    @PropertyMsg(propertyName = "expert_name")
    private String expertName;

    /**
     * 专家类型;专家类型
     */
    @PropertyMsg(propertyName = "expert_type")
    private String expertType;

    /**
     * 总费用;总费用
     */
    @PropertyMsg(propertyName = "sum_fee")
    private BigDecimal sumFee;

    /**
     * 未支付费用;未支付费用
     */
    @PropertyMsg(propertyName = "no_pay_fee")
    private BigDecimal noPayFee;

    /**
     * 已支付费用;已支付费用
     */
    @PropertyMsg(propertyName = "pay_fee")
    private BigDecimal payFee;

    /**
     * 结算周期;结算周期
     */
    @PropertyMsg(propertyName = "money_cycle")
    private String moneyCycle;

    /**
     * 状态
     */
    @PropertyMsg(propertyName = "status")
    private String status;

    /**
     * 备注
     */
    @PropertyMsg(propertyName = "remark")
    private String remark;

    /**
     * 报表id
     */
    @PropertyMsg(propertyName = "statement_id")
    private Long statementId;

    /**
     * 是否删除
     */
    @TableLogic
    @PropertyMsg(propertyName = "del_flag")
    private Long delFlag;


}
