package org.dromara.zjk.statement.service;

import org.dromara.zjk.statement.domain.vo.ZjkMoneyStatementVo;
import org.dromara.zjk.statement.domain.bo.ZjkMoneyStatementBo;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 费用报表Service接口
 *
 * @author ygh
 * @date 2024-12-16
 */
public interface IZjkMoneyStatementService {

    /**
     * 查询费用报表
     *
     * @param id 主键
     * @return 费用报表
     */
    ZjkMoneyStatementVo queryById(Long id);

    /**
     * 分页查询费用报表列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 费用报表分页列表
     */
    TableDataInfo<ZjkMoneyStatementVo> queryPageList(ZjkMoneyStatementBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的费用报表列表
     *
     * @param bo 查询条件
     * @return 费用报表列表
     */
    List<ZjkMoneyStatementVo> queryList(ZjkMoneyStatementBo bo);

    /**
     * 新增费用报表
     *
     * @return 是否新增成功
     */
    Boolean insertByBo();

    /**
     * 修改费用报表
     *
     * @param bo 费用报表
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkMoneyStatementBo bo);

    /**
     * 校验并批量删除费用报表信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    Boolean addYear();
}
