/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.service;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.core.v2.service.ClientOperationService;
import com.alibaba.nacos.naming.core.v2.service.impl.EphemeralClientOperationServiceImpl;
import com.alibaba.nacos.naming.core.v2.service.impl.PersistentClientOperationServiceImpl;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.pojo.Subscriber;
import java.util.List;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"namingSubscriberServiceV2Impl"})
@Component
public class ClientOperationServiceProxy
implements ClientOperationService {
    private final ClientOperationService ephemeralClientOperationService;
    private final ClientOperationService persistentClientOperationService;

    public ClientOperationServiceProxy(EphemeralClientOperationServiceImpl ephemeralClientOperationService, PersistentClientOperationServiceImpl persistentClientOperationService) {
        this.ephemeralClientOperationService = ephemeralClientOperationService;
        this.persistentClientOperationService = persistentClientOperationService;
    }

    @Override
    public void registerInstance(Service service, Instance instance, String clientId) throws NacosException {
        ClientOperationService operationService = this.chooseClientOperationService(instance);
        operationService.registerInstance(service, instance, clientId);
    }

    @Override
    public void batchRegisterInstance(Service service, List<Instance> instances, String clientId) {
        ClientOperationService operationService = this.chooseClientOperationService(instances.get(0));
        operationService.batchRegisterInstance(service, instances, clientId);
    }

    @Override
    public void deregisterInstance(Service service, Instance instance, String clientId) {
        if (!ServiceManager.getInstance().containSingleton(service)) {
            Loggers.SRV_LOG.warn("remove instance from non-exist service: {}", (Object)service);
            return;
        }
        ClientOperationService operationService = this.chooseClientOperationService(instance);
        operationService.deregisterInstance(service, instance, clientId);
    }

    @Override
    public void subscribeService(Service service, Subscriber subscriber, String clientId) {
        this.ephemeralClientOperationService.subscribeService(service, subscriber, clientId);
    }

    @Override
    public void unsubscribeService(Service service, Subscriber subscriber, String clientId) {
        this.ephemeralClientOperationService.unsubscribeService(service, subscriber, clientId);
    }

    private ClientOperationService chooseClientOperationService(Instance instance) {
        return instance.isEphemeral() ? this.ephemeralClientOperationService : this.persistentClientOperationService;
    }
}

