/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.model.form;

import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.http.HttpStatus;

public class InstanceForm
implements Serializable {
    private static final long serialVersionUID = -3760300561436525429L;
    private String namespaceId;
    private String groupName;
    private String serviceName;
    private String ip;
    private String clusterName;
    private Integer port;
    private Boolean healthy;
    private Double weight;
    private Boolean enabled;
    private String metadata;
    private Boolean ephemeral;

    public void validate() throws NacosApiException {
        this.fillDefaultValue();
        if (StringUtils.isBlank((CharSequence)this.serviceName)) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_MISSING, "Required parameter 'serviceName' type String is not present");
        }
        if (StringUtils.isBlank((CharSequence)this.ip)) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_MISSING, "Required parameter 'ip' type String is not present");
        }
        if (this.port == null) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_MISSING, "Required parameter 'port' type Integer is not present");
        }
    }

    public void fillDefaultValue() {
        if (StringUtils.isBlank((CharSequence)this.namespaceId)) {
            this.namespaceId = "public";
        }
        if (StringUtils.isBlank((CharSequence)this.groupName)) {
            this.groupName = "DEFAULT_GROUP";
        }
        if (StringUtils.isBlank((CharSequence)this.clusterName)) {
            this.clusterName = "DEFAULT";
        }
        if (this.healthy == null) {
            this.healthy = true;
        }
        if (this.weight == null) {
            this.weight = 1.0;
        }
        if (this.enabled == null) {
            this.enabled = true;
        }
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Boolean getHealthy() {
        return this.healthy;
    }

    public void setHealthy(Boolean healthy) {
        this.healthy = healthy;
    }

    public Double getWeight() {
        return this.weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public Boolean getEphemeral() {
        return this.ephemeral;
    }

    public void setEphemeral(Boolean ephemeral) {
        this.ephemeral = ephemeral;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceForm that = (InstanceForm)o;
        return Objects.equals(this.namespaceId, that.namespaceId) && Objects.equals(this.groupName, that.groupName) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.ip, that.ip) && Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.port, that.port) && Objects.equals(this.healthy, that.healthy) && Objects.equals(this.weight, that.weight) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.ephemeral, that.ephemeral);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceId, this.groupName, this.serviceName, this.ip, this.clusterName, this.port, this.healthy, this.weight, this.enabled, this.metadata, this.ephemeral);
    }

    public String toString() {
        return "InstanceForm{namespaceId='" + this.namespaceId + '\'' + ", groupName='" + this.groupName + '\'' + ", serviceName='" + this.serviceName + '\'' + ", ip='" + this.ip + '\'' + ", clusterName='" + this.clusterName + '\'' + ", port=" + this.port + ", healthy=" + this.healthy + ", weight=" + this.weight + ", enabled=" + this.enabled + ", metadata='" + this.metadata + '\'' + ", ephemeral=" + this.ephemeral + '}';
    }
}

