/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.monitor;

import com.alibaba.nacos.core.utils.Loggers;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.concurrent.ConcurrentHashMap;

public final class NacosMeterRegistryCenter {
    public static final String CORE_STABLE_REGISTRY = "CORE_STABLE_REGISTRY";
    public static final String CONFIG_STABLE_REGISTRY = "CONFIG_STABLE_REGISTRY";
    public static final String NAMING_STABLE_REGISTRY = "NAMING_STABLE_REGISTRY";
    public static final String TOPN_CONFIG_CHANGE_REGISTRY = "TOPN_CONFIG_CHANGE_REGISTRY";
    public static final String TOPN_SERVICE_CHANGE_REGISTRY = "TOPN_SERVICE_CHANGE_REGISTRY";
    public static final String CONTROL_DENIED_REGISTRY = "CONTROL_DENIED_REGISTRY";
    private static final ConcurrentHashMap<String, CompositeMeterRegistry> METER_REGISTRIES = new ConcurrentHashMap();
    private static CompositeMeterRegistry METER_REGISTRY = null;

    private static void registry(String ... names) {
        for (String name : names) {
            CompositeMeterRegistry compositeMeterRegistry = new CompositeMeterRegistry();
            if (METER_REGISTRY != null) {
                compositeMeterRegistry.add((MeterRegistry)METER_REGISTRY);
            }
            METER_REGISTRIES.put(name, compositeMeterRegistry);
        }
    }

    public static Counter counter(String registry, String name, Iterable<Tag> tags) {
        CompositeMeterRegistry compositeMeterRegistry = METER_REGISTRIES.get(registry);
        if (compositeMeterRegistry != null) {
            return METER_REGISTRIES.get(registry).counter(name, tags);
        }
        return null;
    }

    public static Counter counter(String registry, String name, String ... tags) {
        CompositeMeterRegistry compositeMeterRegistry = METER_REGISTRIES.get(registry);
        if (compositeMeterRegistry != null) {
            return METER_REGISTRIES.get(registry).counter(name, tags);
        }
        return null;
    }

    public static <T extends Number> T gauge(String registry, String name, Iterable<Tag> tags, T number) {
        CompositeMeterRegistry compositeMeterRegistry = METER_REGISTRIES.get(registry);
        if (compositeMeterRegistry != null) {
            return (T)METER_REGISTRIES.get(registry).gauge(name, tags, number);
        }
        return null;
    }

    public static Timer timer(String registry, String name, Iterable<Tag> tags) {
        CompositeMeterRegistry compositeMeterRegistry = METER_REGISTRIES.get(registry);
        if (compositeMeterRegistry != null) {
            return METER_REGISTRIES.get(registry).timer(name, tags);
        }
        return null;
    }

    public static Timer timer(String registry, String name, String ... tags) {
        CompositeMeterRegistry compositeMeterRegistry = METER_REGISTRIES.get(registry);
        if (compositeMeterRegistry != null) {
            return METER_REGISTRIES.get(registry).timer(name, tags);
        }
        return null;
    }

    public static DistributionSummary summary(String registry, String name, Iterable<Tag> tags) {
        CompositeMeterRegistry compositeMeterRegistry = METER_REGISTRIES.get(registry);
        if (compositeMeterRegistry != null) {
            return METER_REGISTRIES.get(registry).summary(name, tags);
        }
        return null;
    }

    public static DistributionSummary summary(String registry, String name, String ... tags) {
        CompositeMeterRegistry compositeMeterRegistry = METER_REGISTRIES.get(registry);
        if (compositeMeterRegistry != null) {
            return METER_REGISTRIES.get(registry).summary(name, tags);
        }
        return null;
    }

    public static void clear(String registry) {
        METER_REGISTRIES.get(registry).clear();
    }

    public static CompositeMeterRegistry getMeterRegistry(String registry) {
        return METER_REGISTRIES.get(registry);
    }

    static {
        try {
            METER_REGISTRY = Metrics.globalRegistry;
        }
        catch (Throwable t) {
            Loggers.CORE.warn("Metrics init failed :", t);
        }
        NacosMeterRegistryCenter.registry(CORE_STABLE_REGISTRY, CONFIG_STABLE_REGISTRY, NAMING_STABLE_REGISTRY, TOPN_CONFIG_CHANGE_REGISTRY, TOPN_SERVICE_CHANGE_REGISTRY, CONTROL_DENIED_REGISTRY);
    }
}

