/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.paramcheck.impl;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.remote.request.BatchInstanceRequest;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.common.paramcheck.ParamInfo;
import com.alibaba.nacos.core.paramcheck.AbstractRpcParamExtractor;
import java.util.ArrayList;
import java.util.List;

public class BatchInstanceRequestParamExtractor
extends AbstractRpcParamExtractor {
    @Override
    public List<ParamInfo> extractParam(Request request) {
        BatchInstanceRequest req = (BatchInstanceRequest)request;
        ParamInfo paramInfo = new ParamInfo();
        paramInfo.setNamespaceId(req.getNamespace());
        paramInfo.setServiceName(req.getServiceName());
        paramInfo.setGroup(req.getGroupName());
        ArrayList<ParamInfo> paramInfos = new ArrayList<ParamInfo>();
        paramInfos.add(paramInfo);
        List instanceList = req.getInstances();
        if (instanceList == null) {
            return paramInfos;
        }
        for (Instance instance : instanceList) {
            ParamInfo instanceParamInfo = new ParamInfo();
            instanceParamInfo.setIp(instance.getIp());
            instanceParamInfo.setPort(String.valueOf(instance.getPort()));
            instanceParamInfo.setServiceName(instance.getServiceName());
            instanceParamInfo.setCluster(instance.getClusterName());
            instanceParamInfo.setMetadata(instance.getMetadata());
            paramInfos.add(instanceParamInfo);
        }
        return paramInfos;
    }
}

