# 专家库完整性约束表格


| 约束名称                               | 表名                        | 字段                     | 约束类型    | 描述                                                                                     |
| -------------------------------------- | --------------------------- | ------------------------ | ----------- | ---------------------------------------------------------------------------------------- |
| pk_zjk_expert_id                       | zjk_expert                  | expert_id                | Primary Key | 主键约束，唯一标识专家记录                                                               |
| fk_zjk_money_info_expert_id            | zjk_expert_money_info       | expert_id                | Foreign Key | 外键约束，关联`zjk_expert.expert_id`                                                     |
| fk_zjk_money_info_product_id           | zjk_expert_money_info       | product_id               | Foreign Key | 外键约束，关联项目表`zjk_product.product_id`                                             |
| fk_zjk_expert_item_expert_id           | zjk_expert_item             | expert_id                | Foreign Key | 外键约束，关联`zjk_expert.expert_id`                                                     |
| fk_zjk_expert_item_item_id             | zjk_expert_item             | item_id                  | Foreign Key | 外键约束，关联评审项目ID                                                                 |
| fk_zjk_evaluate_expert_id              | zjk_evaluate                | expert_id                | Foreign Key | 外键约束，关联专家ID                                                                     |
| fk_zjk_evaluate_item_id                | zjk_evaluate                | item_id                  | Foreign Key | 外键约束，关联评审项目ID                                                                 |
| fk_zjk_invoice_expert_id               | zjk_invoice                 | expert_id                | Foreign Key | 外键约束，关联专家ID                                                                     |
| fk_zjk_point_expert_id                 | zjk_point                   | expert_id                | Foreign Key | 外键约束，关联专家ID                                                                     |
| fk_zjk_annual_inspection_expert_id     | zjk_annual_inspection       | expert_id                | Foreign Key | 外键约束，关联专家ID                                                                     |
| uk_zjk_expert_email                    | zjk_expert                  | email                    | Unique      | 唯一性约束，确保邮箱唯一                                                                 |
| uk_zjk_expert_id_card                  | zjk_expert                  | id_card                  | Unique      | 唯一性约束，确保身份证号唯一                                                             |
| uk_zjk_invoice_number                  | zjk_invoice                 | invoice_number           | Unique      | 唯一性约束，确保发票号码唯一                                                             |
| ck_zjk_expert_status                   | zjk_expert                  | status                   | Check       | 检查约束，状态取值为：0（暂存）、1（待审批）、2（正常）、3（拒绝）、4（离职）、5（退休） |
| ck_zjk_money_info_settlement_status    | zjk_expert_money_info       | status                   | Check       | 检查约束，结算状态取值为：0（未结束）、1（已结算）                                       |
| ck_zjk_expert_annual_inspection_status | zjk_expert                  | annual_inspection_status | Check       | 检查约束，年检状态取值为：1（待年检）、2（已通过）、3（未通过）                          |
| ck_zjk_evaluate_status                 | zjk_evaluate                | status                   | Check       | 检查约束，评价状态取值为：0（未评价）、1（已评价）                                       |
| ck_zjk_leave_status                    | zjk_leave                   | status                   | Check       | 检查约束，请假审批状态取值为预定义范围                                                   |
| ck_zjk_review_phase_effective          | zjk_review_phase            | effective                | Check       | 检查约束，是否有效取值为：0（无效）、1（有效）                                           |
| ck_zjk_money_statement_type            | zjk_money_statement         | type                     | Check       | 检查约束，报表类型取值为：年报、月报                                                     |
| ck_zjk_money_statement_period          | zjk_money_statement         | period                   | Check       | 检查约束，周期取值为：每年、每月                                                         |
| ck_zjk_point_rule_status               | zjk_point_rule              | status                   | Check       | 检查约束，启用标识取值为：0（禁用）、1（启用）                                           |
| ck_zjk_credit_rule_status              | zjk_credit_rule             | status                   | Check       | 检查约束，信用规则启用标识取值为：0（禁用）、1（启用）                                   |
| ck_zjk_money_analyse_tendency          | zjk_money_analyse_statement | tendency                 | Check       | 检查约束，变化趋势取值为预定义范围                                                       |
| ck_zjk_product_reviewsn_status         | zjk_product_reviewsn        | status                   | Check       | 检查约束，文档论文新增表状态取值为预定义范围                                             |
| ck_zjk_learning_activity_status        | zjk_learning_activity       | status                   | Check       | 检查约束，学习活动状态取值为：0（草稿）、1（发布）等                                     |

## 说明

- **主键约束 (Primary Key)**：每个表都有一个主键字段用于唯一标识每条记录。
- **外键约束 (Foreign Key)**：保证数据一致性，防止出现孤立数据。
- **唯一性约束 (Unique)**：确保关键字段如邮箱、身份证号、发票号码等的唯一性。
- **检查约束 (Check)**：对某些字段的取值范围进行限制，保证业务逻辑正确性。
