package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.tenant.core.TenantEntity;
import org.dromara.zjk.annotation.PropertyMsg;

import java.io.Serial;

/**
 * 库 专业关系表对象 zjk_expert_major
 *
 * @author ygh
 * @date 2024-11-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_expert_major")
public class ZjkExpertMajor extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 用户 id
     */
    private Long userId;

    /**
     * 专家 id
     */
    private Long expertId;

    /**
     * 专业
     */
    @PropertyMsg(propertyName = "专业")
    private String major;

    /**
     * 学历
     */
    @PropertyMsg(propertyName = "学历",dictType = "degree_type")
    private Integer degree;

    /**
     * 状态
     */
    private Integer status;

    /**
     * 备注
     */
    private String remark;


}
