package org.dromara.zjk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

@Getter
@AllArgsConstructor
public enum SummarizeStatusEnum {
    to_be_submitted("1","待提交"),
    //to_be_reviewed("2","待审核"),
    to_be_evaluated("3","已完成");
    //rejected("4","已驳回");
    //rated("5","已评价");


    /**
     * 状态
     */
    private final String code;

    /**
     * 描述
     */
    private final String desc;

    // 静态方法：通过 code 获取对应的枚举值
    public static SummarizeStatusEnum getByCode(String code) {
        for (SummarizeStatusEnum status : SummarizeStatusEnum.values()) {
            if (Objects.equals(status.getCode(), code)) {
                return status;
            }
        }
        return null; // 找不到对应 code 的枚举值时返回 null
    }
}
