package org.dromara.zjk.expert.expertPatent.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.dromara.common.mybatis.core.mapper.BaseMapperPlus;
import org.dromara.zjk.expert.expertPatent.domain.ZjkExpertPatent;
import org.dromara.zjk.expert.expertPatent.domain.bo.ZjkExpertPatentBo;
import org.dromara.zjk.expert.expertPatent.domain.vo.ZjkExpertPatentVo;

import java.util.List;

/**
 * 专家专利信息Mapper接口
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
public interface ZjkExpertPatentMapper extends BaseMapperPlus<ZjkExpertPatent, ZjkExpertPatentVo> {

    Page<ZjkExpertPatentVo> selectVoListJoinExpertId(Page<Object> build, ZjkExpertPatentBo bo);
    List<ZjkExpertPatent> selectByExpertId(@Param("expertId") Long expertId);

    List<ZjkExpertPatentVo> patentList(Long productId, String reviewSn);

    Long getExpertPatentCount();
}
