package org.dromara.zjk.learning_world.domain.vo;

import org.dromara.zjk.learning_world.domain.entity.ZjkLearningCommunity;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;


/**
 * 社区管理视图对象 zjk_learning_community
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkLearningCommunity.class)
public class ZjkLearningCommunityVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 社区名称
     */
    @ExcelProperty(value = "社区名称")
    private String communityName;

    /**
     * 社区介绍
     */
    @ExcelProperty(value = "社区介绍")
    private String communityIntroduce;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private Long status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;

    private Long createBy;
    private String userName;
    private String deptName;


}
