package org.dromara.zjk.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.dromara.common.mybatis.core.mapper.BaseMapperPlus;
import org.dromara.zjk.domain.ZjkLeave;
import org.dromara.zjk.domain.bo.ZjkLeaveBo;
import org.dromara.zjk.domain.dto.LeaveRankDto;
import org.dromara.zjk.domain.dto.LeaveStsDto;
import org.dromara.zjk.domain.vo.StsPreVO;
import org.dromara.zjk.domain.vo.ZjkEvaluateVO;
import org.dromara.zjk.domain.vo.ZjkLeaveVo;

import java.util.Date;
import java.util.List;

/**
 * 【请填写功能名称】Mapper接口
 *
 * @author ygh
 * @date 2024-10-30
 */
public interface ZjkLeaveMapper extends BaseMapperPlus<ZjkLeave, ZjkLeaveVo> {
    /**
     * 机构管理员请假审批列表
     *
     * @param bo
     * @return
     */
    IPage<ZjkLeaveVo> selectPageSpList(@Param("page") IPage<ZjkLeaveVo> page, @Param("bo") ZjkLeaveBo bo);

    IPage<ZjkLeaveVo> selectPageAdminLeaveList(Page<Object> build, @Param("bo") ZjkLeaveBo bo);

    ZjkLeaveVo selectLeaveSpDetail(String gid);

    /**
     * 获取用户待参评的项目
     *
     * @param userId
     * @param acceptStatus
     * @return
     */
    List<ZjkEvaluateVO> getLeavePros(Long userId, Integer acceptStatus);

    void updateExpertLeaveStatus(Long userId, String itemId, List<Long> stages);

    /**
     * 通过项目id阶段获取抽取规则id
     *
     * @param itemId
     * @param itemStage
     * @return
     */
    List<Long> getRuleIdsByItemId(String itemId, String itemStage);

    void updateExpertAcceptStatus(Long userId, String itemId, List<Long> stages, String status);

    void updateLeaveStatusRangeTime(Long userId, List<Long> ruleIds);

    /**
     * 请假或未接受时，根据抽取规则修改实际抽取到的人减一
     */
    void updateExtraUserNum(List<Long> reviewIds);

    List<LeaveStsDto> getLeavePerSts(Date ago, Date now);

    List<LeaveStsDto>  getApprovalStu(Date ago, Date now);

    List<LeaveRankDto> getLeaveRanks(Date ago, Date now);
}
