package org.dromara.zjk.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.dromara.common.core.utils.MapstructUtils;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.RequiredArgsConstructor;
import org.dromara.common.satoken.utils.LoginHelper;
import org.dromara.zjk.domain.ZjkLearningMaterials;
import org.dromara.zjk.domain.vo.ZjkLearningMaterialsVo;
import org.dromara.zjk.mapper.ZjkLearningMaterialsMapper;
import org.redisson.misc.LogHelper;
import org.springframework.stereotype.Service;
import org.dromara.zjk.domain.bo.ZjkLearningCreditRecordBo;
import org.dromara.zjk.domain.vo.ZjkLearningCreditRecordVo;
import org.dromara.zjk.domain.ZjkLearningCreditRecord;
import org.dromara.zjk.mapper.ZjkLearningCreditRecordMapper;
import org.dromara.zjk.service.IZjkLearningCreditRecordService;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 信用用户学习记录Service业务层处理
 *
 * @author ygh
 * @date 2024-11-26
 */
@RequiredArgsConstructor
@Service
public class ZjkLearningCreditRecordServiceImpl implements IZjkLearningCreditRecordService {

    private final ZjkLearningCreditRecordMapper baseMapper;
    private final ZjkLearningMaterialsMapper zjkLearningMaterialsMapper;

    /**
     * 查询信用用户学习记录
     *
     * @param id 主键
     * @return 信用用户学习记录
     */
    @Override
    public List<ZjkLearningCreditRecordVo> queryById(Long id){
        //当前专家的观看记录
        LambdaQueryWrapper<ZjkLearningCreditRecord> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(ZjkLearningCreditRecord::getUserId,id);
        lambdaQueryWrapper.orderByDesc(ZjkLearningCreditRecord::getCreateTime);
        List<ZjkLearningCreditRecordVo> zjkLearningCreditRecordVos = baseMapper.selectVoList(lambdaQueryWrapper);
        //信用资料
        for (ZjkLearningCreditRecordVo zjkLearningCreditRecordVo : zjkLearningCreditRecordVos) {
            Long learningId = zjkLearningCreditRecordVo.getLearningId();
            ZjkLearningMaterialsVo zjkLearningMaterialsVo = zjkLearningMaterialsMapper.selectVoById(learningId);
            zjkLearningCreditRecordVo.setZjkLearningMaterialsVo(zjkLearningMaterialsVo);
        }
        return zjkLearningCreditRecordVos;
    }

    /**
     * 分页查询信用用户学习记录列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 信用用户学习记录分页列表
     */
    @Override
    public TableDataInfo<ZjkLearningCreditRecordVo> queryPageList(ZjkLearningCreditRecordBo bo, PageQuery pageQuery) {
        LambdaQueryWrapper<ZjkLearningCreditRecord> lqw = buildQueryWrapper(bo);
        Page<ZjkLearningCreditRecordVo> result = baseMapper.selectVoPage(pageQuery.build(), lqw);
        return TableDataInfo.build(result);
    }

    /**
     * 查询符合条件的信用用户学习记录列表
     *
     * @param bo 查询条件
     * @return 信用用户学习记录列表
     */
    @Override
    public List<ZjkLearningCreditRecordVo> queryList(ZjkLearningCreditRecordBo bo) {
        LambdaQueryWrapper<ZjkLearningCreditRecord> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<ZjkLearningCreditRecord> buildQueryWrapper(ZjkLearningCreditRecordBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZjkLearningCreditRecord> lqw = Wrappers.lambdaQuery();
        lqw.eq(bo.getRevision() != null, ZjkLearningCreditRecord::getRevision, bo.getRevision());
        lqw.eq(bo.getUserId() != null, ZjkLearningCreditRecord::getUserId, bo.getUserId());
        lqw.eq(bo.getLearningId() != null, ZjkLearningCreditRecord::getLearningId, bo.getLearningId());
        lqw.eq(bo.getViewingTime() != null, ZjkLearningCreditRecord::getViewingTime, bo.getViewingTime());
        lqw.eq(bo.getDelFalg() != null, ZjkLearningCreditRecord::getDelFalg, bo.getDelFalg());
        lqw.orderByDesc(ZjkLearningCreditRecord::getCreateTime);
        return lqw;
    }

    /**
     * 新增信用用户学习记录
     *
     * @param bo 信用用户学习记录
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByBo(ZjkLearningCreditRecordBo bo) {
        ZjkLearningCreditRecord add = MapstructUtils.convert(bo, ZjkLearningCreditRecord.class);
        add.setViewingTime(new Date());
        add.setUserId(LoginHelper.getUserId());
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setId(add.getId());
        }
        //修改资料观看次数+1
        ZjkLearningMaterials zjkLearningMaterials = new ZjkLearningMaterials();
        zjkLearningMaterials.setId(add.getLearningId());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.setSql("materials_count = materials_count + 1");
        zjkLearningMaterialsMapper.update(zjkLearningMaterials,updateWrapper);
        return flag;
    }

    /**
     * 修改信用用户学习记录
     *
     * @param bo 信用用户学习记录
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByBo(ZjkLearningCreditRecordBo bo) {
        ZjkLearningCreditRecord update = MapstructUtils.convert(bo, ZjkLearningCreditRecord.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(ZjkLearningCreditRecord entity){
        //TODO 做一些数据校验,如唯一约束
    }

    /**
     * 校验并批量删除信用用户学习记录信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteByIds(ids) > 0;
    }
}
