package org.dromara.zjk.statement.domain.bo;

import org.dromara.zjk.statement.domain.ZjkMoneyCollectStatement;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import java.math.BigDecimal;

/**
 * 报表统计业务对象 zjk_money_collect_statement
 *
 * @author wt
 * @date 2024-12-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkMoneyCollectStatement.class, reverseConvertGenerate = false)
public class ZjkMoneyCollectStatementBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long id;

    /**
     * 支付总金额;支付总金额
     */
    @NotNull(message = "支付总金额;支付总金额不能为空", groups = { AddGroup.class, EditGroup.class })
    private BigDecimal sumFee;

    /**
     * 未支付金额;未支付金额
     */
    @NotNull(message = "未支付金额;未支付金额不能为空", groups = { AddGroup.class, EditGroup.class })
    private BigDecimal noPayMoney;

    /**
     * 支付金额;支付金额
     */
    @NotNull(message = "支付金额;支付金额不能为空", groups = { AddGroup.class, EditGroup.class })
    private BigDecimal payMoney;

    /**
     * 专家人数;专家人数
     */
    @NotNull(message = "专家人数;专家人数不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long expertCount;

    /**
     * 结算周期;结算周期
     */
    @NotBlank(message = "结算周期;结算周期不能为空", groups = { AddGroup.class, EditGroup.class })
    private String moneyCycle;

    /**
     * 状态
     */
    @NotBlank(message = "状态不能为空", groups = { AddGroup.class, EditGroup.class })
    private String status;

    /**
     * 备注
     */
    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;


    /**
     * 报表id
     */
    private Long statementId;
}
