/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.api.grpc.auto.Payload;
import com.alibaba.nacos.api.remote.DefaultRequestFuture;
import com.alibaba.nacos.api.remote.RequestCallBack;
import com.alibaba.nacos.api.remote.RequestFuture;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.common.remote.client.grpc.GrpcUtils;
import com.alibaba.nacos.common.remote.exception.ConnectionAlreadyClosedException;
import com.alibaba.nacos.common.remote.exception.ConnectionBusyException;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.ConnectionMeta;
import com.alibaba.nacos.core.remote.RpcAckCallbackSynchronizer;
import com.alibaba.nacos.core.remote.grpc.PushAckIdGenerator;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.control.ControlManagerCenter;
import com.alibaba.nacos.plugin.control.tps.TpsControlManager;
import com.alibaba.nacos.plugin.control.tps.request.TpsCheckRequest;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.util.concurrent.Future;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.ExecutionException;

public class GrpcConnection
extends Connection {
    private StreamObserver streamObserver;
    private Channel channel;
    private static TpsControlManager tpsControlManager;

    public GrpcConnection(ConnectionMeta metaInfo, StreamObserver streamObserver, Channel channel) {
        super(metaInfo);
        this.streamObserver = streamObserver;
        this.channel = channel;
    }

    public void sendRequestNoAck(Request request) throws NacosException {
        this.sendQueueBlockCheck();
        Future executeFuture = this.channel.eventLoop().submit(() -> {
            StreamObserver streamObserver = this.streamObserver;
            synchronized (streamObserver) {
                try {
                    Payload payload = GrpcUtils.convert((Request)request);
                    this.traceIfNecessary(payload);
                    this.streamObserver.onNext((Object)payload);
                    return true;
                }
                catch (Throwable e) {
                    if (e instanceof StatusRuntimeException) {
                        throw new ConnectionAlreadyClosedException(e);
                    }
                    if (e instanceof IllegalStateException) {
                        throw new ConnectionAlreadyClosedException(e);
                    }
                    throw new NacosRuntimeException(500, e);
                }
            }
        });
        try {
            executeFuture.get();
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExecutionException && throwable.getCause() != null && throwable.getCause() instanceof NacosRuntimeException) {
                throw (NacosRuntimeException)throwable.getCause();
            }
            throw new NacosRuntimeException(500, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQueueBlockCheck() {
        if (this.streamObserver instanceof ServerCallStreamObserver) {
            boolean ready = ((ServerCallStreamObserver)this.streamObserver).isReady();
            if (!ready) {
                if (tpsControlManager == null) {
                    Class<?> clazz = GrpcConnection.class.getClass();
                    synchronized (clazz) {
                        if (tpsControlManager == null) {
                            tpsControlManager = ControlManagerCenter.getInstance().getTpsControlManager();
                            tpsControlManager.registerTpsPoint("SERVER_PUSH_BLOCK");
                        }
                    }
                }
                TpsCheckRequest tpsCheckRequest = new TpsCheckRequest("SERVER_PUSH_BLOCK", this.getMetaInfo().getConnectionId(), this.getMetaInfo().getClientIp());
                tpsControlManager.check(tpsCheckRequest);
                this.getMetaInfo().recordPushQueueBlockTimes();
                throw new ConnectionBusyException("too much bytes on sending queue of this stream.");
            }
            this.getMetaInfo().clearPushQueueBlockTimes();
        }
    }

    private void traceIfNecessary(Payload payload) {
        String connectionId = null;
        if (this.isTraced()) {
            try {
                connectionId = this.getMetaInfo().getConnectionId();
                Loggers.REMOTE_DIGEST.info("[{}]Send request to client ,payload={}", (Object)connectionId, (Object)payload.toByteString().toStringUtf8());
            }
            catch (Throwable throwable) {
                Loggers.REMOTE_DIGEST.warn("[{}]Send request to client trace error, ,error={}", (Object)connectionId, (Object)throwable);
            }
        }
    }

    private DefaultRequestFuture sendRequestInner(Request request, RequestCallBack callBack) throws NacosException {
        String requestId = String.valueOf(PushAckIdGenerator.getNextId());
        request.setRequestId(requestId);
        DefaultRequestFuture defaultPushFuture = new DefaultRequestFuture(this.getMetaInfo().getConnectionId(), requestId, callBack, () -> RpcAckCallbackSynchronizer.clearFuture(this.getMetaInfo().getConnectionId(), requestId));
        RpcAckCallbackSynchronizer.syncCallback(this.getMetaInfo().getConnectionId(), requestId, defaultPushFuture);
        this.sendRequestNoAck(request);
        return defaultPushFuture;
    }

    public Response request(Request request, long timeoutMills) throws NacosException {
        DefaultRequestFuture pushFuture = this.sendRequestInner(request, null);
        try {
            Response response = pushFuture.get(timeoutMills);
            return response;
        }
        catch (Exception e) {
            throw new NacosException(500, (Throwable)e);
        }
        finally {
            RpcAckCallbackSynchronizer.clearFuture(this.getMetaInfo().getConnectionId(), pushFuture.getRequestId());
        }
    }

    public RequestFuture requestFuture(Request request) throws NacosException {
        return this.sendRequestInner(request, null);
    }

    public void asyncRequest(Request request, RequestCallBack requestCallBack) throws NacosException {
        this.sendRequestInner(request, requestCallBack);
    }

    public void close() {
        String connectionId = null;
        try {
            connectionId = this.getMetaInfo().getConnectionId();
            if (this.isTraced()) {
                Loggers.REMOTE_DIGEST.warn("[{}] try to close connection ", (Object)connectionId);
            }
            try {
                this.closeBiStream();
            }
            catch (Throwable e) {
                Loggers.REMOTE_DIGEST.warn("[{}] connection  close bi stream exception  : {}", (Object)connectionId, (Object)e);
            }
            this.channel.close();
        }
        catch (Exception e) {
            Loggers.REMOTE_DIGEST.warn("[{}] connection  close exception  : {}", (Object)connectionId, (Object)e);
        }
    }

    private void closeBiStream() {
        ServerCallStreamObserver serverCallStreamObserver;
        if (this.streamObserver instanceof ServerCallStreamObserver && !(serverCallStreamObserver = (ServerCallStreamObserver)this.streamObserver).isCancelled()) {
            serverCallStreamObserver.onCompleted();
        }
    }

    @Override
    public boolean isConnected() {
        return this.channel != null && this.channel.isOpen() && this.channel.isActive();
    }
}

