/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.aspect;

import com.alibaba.nacos.api.config.remote.request.ConfigPublishRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigRemoveRequest;
import com.alibaba.nacos.api.config.remote.response.ConfigPublishResponse;
import com.alibaba.nacos.api.config.remote.response.ConfigRemoveResponse;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.ResponseCode;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.config.server.configuration.ConfigChangeConfigs;
import com.alibaba.nacos.config.server.model.SameConfigPolicy;
import com.alibaba.nacos.config.server.utils.ConfigExecutor;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.plugin.config.ConfigChangePluginManager;
import com.alibaba.nacos.plugin.config.constants.ConfigChangeExecuteTypes;
import com.alibaba.nacos.plugin.config.constants.ConfigChangePointCutTypes;
import com.alibaba.nacos.plugin.config.model.ConfigChangeRequest;
import com.alibaba.nacos.plugin.config.model.ConfigChangeResponse;
import com.alibaba.nacos.plugin.config.spi.ConfigChangePluginService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class ConfigChangeAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigChangeAspect.class);
    private static final Integer DEFAULT_BEFORE_LIST_CAPACITY = 2;
    private static final Integer DEFAULT_AFTER_LIST_CAPACITY = 1;
    private static final String ENABLED = "enabled";
    private static final String CLIENT_INTERFACE_PUBLISH_CONFIG = "execution(* com.alibaba.nacos.config.server.controller.ConfigController.publishConfig(..)) && args(request,response,dataId,group,tenant,content,tag,appName,srcUser,configTags,desc,use,effect,type,..) && @annotation(org.springframework.web.bind.annotation.PostMapping)";
    private static final String CLIENT_INTERFACE_PUBLISH_CONFIG_RPC = "execution(* com.alibaba.nacos.core.remote.RequestHandler.handleRequest(..)) && target(com.alibaba.nacos.config.server.remote.ConfigPublishRequestHandler) && args(request,meta)";
    private static final String CLIENT_INTERFACE_REMOVE_CONFIG = "execution(* com.alibaba.nacos.config.server.controller.ConfigController.deleteConfig(..)) && args(request,response,dataId,group,tenant,..)";
    private static final String CLIENT_INTERFACE_BATCH_REMOVE_CONFIG = "execution(* com.alibaba.nacos.config.server.controller.ConfigController.deleteConfigs(..)) && args(request,ids)";
    private static final String CLIENT_INTERFACE_REMOVE_CONFIG_RPC = "execution(* com.alibaba.nacos.core.remote.RequestHandler.handleRequest(..))  && target(com.alibaba.nacos.config.server.remote.ConfigRemoveRequestHandler) && args(request,meta)";
    private static final String CLIENT_INTERFACE_IMPORT_CONFIG = "execution(* com.alibaba.nacos.config.server.controller.ConfigController.importAndPublishConfig(..)) && args(request,srcUser,namespace,policy,file)";
    private final ConfigChangeConfigs configChangeConfigs;
    private ConfigChangePluginManager configChangeManager;

    public ConfigChangeAspect(ConfigChangeConfigs configChangeConfigs) {
        this.configChangeConfigs = configChangeConfigs;
        this.configChangeManager = ConfigChangePluginManager.getInstance();
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.controller.ConfigController.publishConfig(..)) && args(request,response,dataId,group,tenant,content,tag,appName,srcUser,configTags,desc,use,effect,type,..) && @annotation(org.springframework.web.bind.annotation.PostMapping)")
    Object publishOrUpdateConfigAround(ProceedingJoinPoint pjp, HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant, String content, String tag, String appName, String srcUser, String configTags, String desc, String use, String effect, String type) throws Throwable {
        ConfigChangePointCutTypes configChangePointCutType = ConfigChangePointCutTypes.PUBLISH_BY_HTTP;
        List<ConfigChangePluginService> pluginServices = this.getPluginServices(configChangePointCutType);
        if (pluginServices.isEmpty()) {
            return pjp.proceed();
        }
        ConfigChangeRequest configChangeRequest = new ConfigChangeRequest(configChangePointCutType);
        configChangeRequest.setArg("dataId", (Object)dataId);
        configChangeRequest.setArg("group", (Object)group);
        configChangeRequest.setArg("tenant", (Object)tenant);
        configChangeRequest.setArg("content", (Object)content);
        configChangeRequest.setArg("tag", (Object)tag);
        configChangeRequest.setArg("requestIpApp", (Object)appName);
        configChangeRequest.setArg("srcIp", (Object)RequestUtil.getRemoteIp(request));
        configChangeRequest.setArg("configTags", (Object)configTags);
        configChangeRequest.setArg("desc", (Object)desc);
        configChangeRequest.setArg("use", (Object)use);
        configChangeRequest.setArg("effect", (Object)effect);
        configChangeRequest.setArg("type", (Object)type);
        return this.configChangeServiceHandle(pjp, pluginServices, configChangeRequest);
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.controller.ConfigController.deleteConfig(..)) && args(request,response,dataId,group,tenant,..)")
    Object removeConfigByIdAround(ProceedingJoinPoint pjp, HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant) throws Throwable {
        ConfigChangePointCutTypes configChangePointCutType = ConfigChangePointCutTypes.REMOVE_BY_HTTP;
        List<ConfigChangePluginService> pluginServices = this.getPluginServices(configChangePointCutType);
        if (pluginServices.isEmpty()) {
            return pjp.proceed();
        }
        ConfigChangeRequest configChangeRequest = new ConfigChangeRequest(configChangePointCutType);
        configChangeRequest.setArg("dataId", (Object)dataId);
        configChangeRequest.setArg("group", (Object)group);
        configChangeRequest.setArg("tenant", (Object)tenant);
        configChangeRequest.setArg("srcIp", (Object)RequestUtil.getRemoteIp(request));
        configChangeRequest.setArg("requestIpApp", (Object)RequestUtil.getAppName(request));
        configChangeRequest.setArg("use", (Object)RequestUtil.getSrcUserName(request));
        return this.configChangeServiceHandle(pjp, pluginServices, configChangeRequest);
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.controller.ConfigController.deleteConfigs(..)) && args(request,ids)")
    public Object removeConfigByIdsAround(ProceedingJoinPoint pjp, HttpServletRequest request, List<Long> ids) throws Throwable {
        ConfigChangePointCutTypes configChangePointCutType = ConfigChangePointCutTypes.REMOVE_BATCH_HTTP;
        List<ConfigChangePluginService> pluginServices = this.getPluginServices(configChangePointCutType);
        if (pluginServices.isEmpty()) {
            return pjp.proceed();
        }
        ConfigChangeRequest configChangeRequest = new ConfigChangeRequest(configChangePointCutType);
        configChangeRequest.setArg("dataId", (Object)ids.toString());
        configChangeRequest.setArg("srcIp", (Object)RequestUtil.getRemoteIp(request));
        configChangeRequest.setArg("requestIpApp", (Object)RequestUtil.getAppName(request));
        configChangeRequest.setArg("use", (Object)RequestUtil.getSrcUserName(request));
        return this.configChangeServiceHandle(pjp, pluginServices, configChangeRequest);
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.controller.ConfigController.importAndPublishConfig(..)) && args(request,srcUser,namespace,policy,file)")
    public Object importConfigAround(ProceedingJoinPoint pjp, HttpServletRequest request, String srcUser, String namespace, SameConfigPolicy policy, MultipartFile file) throws Throwable {
        ConfigChangePointCutTypes configChangePointCutType = ConfigChangePointCutTypes.IMPORT_BY_HTTP;
        List<ConfigChangePluginService> pluginServices = this.getPluginServices(configChangePointCutType);
        if (pluginServices.isEmpty()) {
            return pjp.proceed();
        }
        ConfigChangeRequest configChangeRequest = new ConfigChangeRequest(configChangePointCutType);
        configChangeRequest.setArg("srcUser", (Object)srcUser);
        configChangeRequest.setArg("namespace", (Object)namespace);
        configChangeRequest.setArg("policy", (Object)policy);
        configChangeRequest.setArg("file", (Object)file);
        configChangeRequest.setArg("srcIp", (Object)RequestUtil.getRemoteIp(request));
        configChangeRequest.setArg("requestIpApp", (Object)RequestUtil.getAppName(request));
        configChangeRequest.setArg("use", (Object)RequestUtil.getSrcUserName(request));
        return this.configChangeServiceHandle(pjp, pluginServices, configChangeRequest);
    }

    @Around(value="execution(* com.alibaba.nacos.core.remote.RequestHandler.handleRequest(..)) && target(com.alibaba.nacos.config.server.remote.ConfigPublishRequestHandler) && args(request,meta)")
    Object publishConfigAroundRpc(ProceedingJoinPoint pjp, ConfigPublishRequest request, RequestMeta meta) throws Throwable {
        ConfigChangePointCutTypes configChangePointCutType = ConfigChangePointCutTypes.PUBLISH_BY_RPC;
        List<ConfigChangePluginService> pluginServices = this.getPluginServices(configChangePointCutType);
        if (pluginServices.isEmpty()) {
            return pjp.proceed();
        }
        ConfigChangeRequest configChangeRequest = new ConfigChangeRequest(configChangePointCutType);
        configChangeRequest.setArg("dataId", (Object)request.getDataId());
        configChangeRequest.setArg("group", (Object)request.getGroup());
        configChangeRequest.setArg("tenant", (Object)request.getTenant());
        configChangeRequest.setArg("content", (Object)request.getContent());
        configChangeRequest.setArg("type", (Object)request.getAdditionParam("type"));
        configChangeRequest.setArg("tag", (Object)request.getAdditionParam("tag"));
        configChangeRequest.setArg("configTags", (Object)request.getAdditionParam("config_tags"));
        configChangeRequest.setArg("desc", (Object)request.getAdditionParam("desc"));
        configChangeRequest.setArg("effect", (Object)request.getAdditionParam("effect"));
        configChangeRequest.setArg("appName", (Object)request.getAdditionParam("appName"));
        configChangeRequest.setArg("srcIp", (Object)meta.getClientIp());
        configChangeRequest.setArg("requestIpApp", (Object)request.getAdditionParam("requestIpApp"));
        configChangeRequest.setArg("srcUser", (Object)request.getAdditionParam("src_user"));
        configChangeRequest.setArg("use", (Object)request.getAdditionParam("use"));
        return this.configChangeServiceHandle(pjp, pluginServices, configChangeRequest);
    }

    @Around(value="execution(* com.alibaba.nacos.core.remote.RequestHandler.handleRequest(..))  && target(com.alibaba.nacos.config.server.remote.ConfigRemoveRequestHandler) && args(request,meta)")
    Object removeConfigAroundRpc(ProceedingJoinPoint pjp, ConfigRemoveRequest request, RequestMeta meta) throws Throwable {
        ConfigChangePointCutTypes configChangePointCutType = ConfigChangePointCutTypes.REMOVE_BY_RPC;
        List<ConfigChangePluginService> pluginServices = this.getPluginServices(configChangePointCutType);
        if (pluginServices.isEmpty()) {
            return pjp.proceed();
        }
        ConfigChangeRequest configChangeRequest = new ConfigChangeRequest(configChangePointCutType);
        configChangeRequest.setArg("dataId", (Object)request.getDataId());
        configChangeRequest.setArg("group", (Object)request.getGroup());
        configChangeRequest.setArg("tenant", (Object)request.getTenant());
        configChangeRequest.setArg("appName", (Object)request.getHeader("appName"));
        configChangeRequest.setArg("srcIp", (Object)meta.getClientIp());
        configChangeRequest.setArg("requestIpApp", (Object)request.getHeader("requestIpApp"));
        configChangeRequest.setArg("srcUser", (Object)request.getHeader("src_user"));
        configChangeRequest.setArg("use", (Object)request.getHeader("use"));
        return this.configChangeServiceHandle(pjp, pluginServices, configChangeRequest);
    }

    private Object configChangeServiceHandle(ProceedingJoinPoint pjp, List<ConfigChangePluginService> configChangePluginServiceList, ConfigChangeRequest configChangeRequest) {
        configChangeRequest.setArg("modifyTime", (Object)TimeUtils.getCurrentTimeStr());
        ConfigChangePointCutTypes handleType = configChangeRequest.getRequestType();
        ConfigChangeResponse configChangeResponse = new ConfigChangeResponse(handleType);
        configChangeResponse.setSuccess(true);
        ArrayList<ConfigChangePluginService> beforeExecutePluginServices = new ArrayList<ConfigChangePluginService>(DEFAULT_BEFORE_LIST_CAPACITY);
        ArrayList<ConfigChangePluginService> afterExecutePluginServices = new ArrayList<ConfigChangePluginService>(DEFAULT_AFTER_LIST_CAPACITY);
        Object retVal = null;
        Object[] args = pjp.getArgs();
        configChangeRequest.setArg("originalArgs", (Object)args);
        for (ConfigChangePluginService ccs : configChangePluginServiceList) {
            if (!this.isEnabled(ccs)) continue;
            if (ConfigChangeExecuteTypes.EXECUTE_BEFORE_TYPE.equals(ccs.executeType())) {
                beforeExecutePluginServices.add(ccs);
                continue;
            }
            afterExecutePluginServices.add(ccs);
        }
        for (ConfigChangePluginService ccs : beforeExecutePluginServices) {
            String serviceType = ccs.getServiceType().toLowerCase(Locale.ROOT);
            Properties properties = this.configChangeConfigs.getPluginProperties(serviceType);
            configChangeRequest.setArg("pluginProperties", (Object)properties);
            ccs.execute(configChangeRequest, configChangeResponse);
            if (null != configChangeResponse.getArgs()) {
                args = configChangeResponse.getArgs();
            }
            if (configChangeResponse.isSuccess()) continue;
            retVal = this.wrapErrorResp(configChangeResponse);
            break;
        }
        try {
            if (configChangeResponse.isSuccess()) {
                retVal = pjp.proceed(args);
            }
        }
        catch (Throwable e) {
            LOGGER.warn("config change join point failed {}", (Object)e.getMessage());
            configChangeResponse.setMsg("config change join point fail" + e.getMessage());
            retVal = this.wrapErrorResp(configChangeResponse);
        }
        ConfigExecutor.executeAsyncConfigChangePluginTask(() -> {
            for (ConfigChangePluginService ccs : afterExecutePluginServices) {
                try {
                    String serviceType = ccs.getServiceType().toLowerCase(Locale.ROOT);
                    Properties properties = this.configChangeConfigs.getPluginProperties(serviceType);
                    configChangeRequest.setArg("pluginProperties", (Object)properties);
                    ccs.execute(configChangeRequest, configChangeResponse);
                }
                catch (Throwable throwable) {
                    LOGGER.warn("execute async plugin services failed {}", (Object)throwable.getMessage());
                }
            }
        });
        return retVal;
    }

    private List<ConfigChangePluginService> getPluginServices(ConfigChangePointCutTypes configChangePointCutType) {
        List pluginServicePriorityList = ConfigChangePluginManager.findPluginServicesByPointcut((ConfigChangePointCutTypes)configChangePointCutType);
        if (pluginServicePriorityList == null) {
            return new ArrayList<ConfigChangePluginService>();
        }
        for (ConfigChangePluginService each : pluginServicePriorityList) {
            if (!this.isEnabled(each)) continue;
            return pluginServicePriorityList;
        }
        return new ArrayList<ConfigChangePluginService>();
    }

    private boolean isEnabled(ConfigChangePluginService configChangePluginService) {
        Properties serviceConfigProperties = this.configChangeConfigs.getPluginProperties(configChangePluginService.getServiceType());
        return Boolean.parseBoolean(serviceConfigProperties.getProperty(ENABLED));
    }

    private Object wrapErrorResp(ConfigChangeResponse configChangeResponse) {
        RestResult retVal = null;
        switch (configChangeResponse.getResponseType()) {
            case IMPORT_BY_HTTP: 
            case REMOVE_BATCH_HTTP: 
            case REMOVE_BY_HTTP: 
            case PUBLISH_BY_HTTP: {
                retVal = RestResultUtils.failed((String)configChangeResponse.getMsg());
                break;
            }
            case PUBLISH_BY_RPC: {
                retVal = ConfigPublishResponse.buildFailResponse((int)ResponseCode.FAIL.getCode(), (String)configChangeResponse.getMsg());
                break;
            }
            case REMOVE_BY_RPC: {
                retVal = ConfigRemoveResponse.buildFailResponse((String)configChangeResponse.getMsg());
                break;
            }
        }
        return retVal;
    }
}

