package org.dromara.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.dromara.common.core.domain.R;
import org.dromara.common.redis.config.RedisConfiguration;
import org.dromara.common.redis.utils.RedisUtils;
import org.dromara.system.domain.SysAreas;
import org.dromara.system.domain.SysCities;
import org.dromara.system.domain.SysProvinces;
import org.dromara.system.domain.vo.SysAreasVo;
import org.dromara.system.domain.vo.SysCitiesVo;
import org.dromara.system.domain.vo.SysProvinceCAVo;
import org.dromara.system.mapper.SysAreasMapper;
import org.dromara.system.mapper.SysCitiesMapper;
import org.dromara.system.mapper.SysProvincesMapper;
import org.dromara.system.service.SysProvincesService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* @author EDY
* @description 针对表【sys_provinces(省份信息表)】的数据库操作Service实现
* @createDate 2024-11-04 16:20:23
*/
@Service
public class SysProvincesServiceImpl extends ServiceImpl<SysProvincesMapper, SysProvinces>
    implements SysProvincesService{
    @Resource
    private SysCitiesMapper sysCitiesMapper;
    @Resource
    private SysAreasMapper sysAreasMapper;

    private RedisConfiguration redisConfiguration;

    @Override
    public R<List<SysCities>> getCitiesByProvince(Long provinceId) {
        QueryWrapper<SysCities> qw = new QueryWrapper<>();
        qw.lambda().eq(SysCities::getProvinceid,provinceId);
        List<SysCities> sysCities = sysCitiesMapper.selectList(qw);
        return R.ok(sysCities);
    }

    @Override
    public R<List<SysAreas>> getAreasByCity(Long cityId) {
        QueryWrapper<SysAreas> qw = new QueryWrapper<>();
        qw.lambda().eq(SysAreas::getCityid,cityId);
        List<SysAreas> sysAreas = sysAreasMapper.selectList(qw);
        return R.ok(sysAreas);
    }

    @Override
    public List<SysProvinceCAVo> getProvince() {
        LambdaQueryWrapper<SysProvinces> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.orderBy(true,true,SysProvinces::getSort);
        List<SysProvinces> list = baseMapper.selectList(lambdaQueryWrapper);
        //从redis中获取
//        RedisUtils.deleteKeys("redissonProperties");
        List<SysProvinceCAVo> redissonProperties = RedisUtils.getCacheList("redissonProperties");
        if(redissonProperties!=null&&redissonProperties.size()>0){
            return redissonProperties;
        }

        List<SysProvinceCAVo> list1 = new ArrayList<>();
        for (SysProvinces sysProvinces : list) {
            SysProvinceCAVo sysProvinceCAVo= new SysProvinceCAVo();
            sysProvinceCAVo.setName(sysProvinces.getProvince());
            sysProvinceCAVo.setCode(sysProvinces.getProvinceid());
            sysProvinceCAVo.setId(sysProvinces.getId());
            R<List<SysCities>> citiesByProvince = getCitiesByProvince(Long.parseLong(sysProvinces.getProvinceid().toString()));
            List<SysCities> data = citiesByProvince.getData();
            List<SysCitiesVo> sysCitiesVoList = new ArrayList<>();
            for (SysCities datum : data) {
                SysCitiesVo sysCitiesVo = new SysCitiesVo();
                sysCitiesVo.setCode(datum.getCityid());
                sysCitiesVo.setProvinceid(datum.getProvinceid());
                sysCitiesVo.setName(datum.getCity());
                R<List<SysAreas>> areasByCity = getAreasByCity(Long.parseLong(datum.getCityid().toString()));
                List<SysAreas> data1 = areasByCity.getData();
                List<SysAreasVo> sysAreasVoList = new ArrayList<>();
                for (SysAreas sysAreas : data1) {
                    SysAreasVo sysAreasVo = new SysAreasVo();
                    sysAreasVo.setCityid(sysAreas.getCityid());
                    sysAreasVo.setCode(sysAreas.getAreaid());
                    sysAreasVo.setName(sysAreas.getArea());
                    sysAreasVoList.add(sysAreasVo);
                }
                sysCitiesVo.setCodeName(sysAreasVoList);
                sysCitiesVoList.add(sysCitiesVo);
            }
            sysProvinceCAVo.setCodeName(sysCitiesVoList);
            list1.add(sysProvinceCAVo);
        }
        RedisUtils.setCacheList("redissonProperties",list1);
        return list1;
    }

    @Override
    public Map<String, String> getRegionNames(Long provinceId, Long cityId, Long areaId) {
        Map<String, String> regionNames = new HashMap<>();
        SysCities sysCities = sysCitiesMapper.selectOne(new LambdaQueryWrapper<SysCities>().eq(SysCities::getCityid,cityId));
        SysProvinces sysProvinces = baseMapper.selectOne(new LambdaQueryWrapper<SysProvinces>().eq(SysProvinces::getProvinceid,provinceId));
        SysAreas sysAreas = sysAreasMapper.selectOne(new LambdaQueryWrapper<SysAreas>().eq(SysAreas::getAreaid,areaId));
        regionNames.put("provinceName", sysProvinces != null ? sysProvinces.getProvince() : "未知省份");
        regionNames.put("cityName", sysCities != null ? sysCities.getCity() : "未知城市");
        regionNames.put("districtName", sysAreas != null ? sysAreas.getArea() : "未知地区");
        return regionNames;
    }
}




