package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import org.dromara.common.mybatis.core.domain.BaseEntity;

/**
 * 请假申请表
 * @author EDY
 * @TableName zjk_leave
 */
@TableName(value ="zjk_leave")
@Data
public class ZjkLeave  implements Serializable {
    /**
     * 主键
     */
    @TableId(value = "gid",type = IdType.ASSIGN_ID)
    private String gid;

    /**
     * 请假类型
     */
    @TableField(value = "leave_type")
    private String leaveType;

    /**
     * 开始时间
     */
    @TableField(value = "start_date")
    private Date startDate;

    /**
     * 结束时间
     */
    @TableField(value = "end_date")
    private Date endDate;

    /**
     * 请假天数
     */
    @TableField(value = "leave_days")
    private Long leaveDays;

    /**
     * 请假原因
     */
    @TableField(value = "leave_reason")
    private String leaveReason;

    /**
     * 1:同意
     */
    @TableField(value = "status")
    private String status;

    /**
     * 审批人
     */
    @TableField(value = "approval_user")
    private String approvalUser;

    /**
     * 租户编码
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 审批备注
     */
    @TableField(value = "approval_msg")
    private String approvalMsg;
    /**
     * 0:个人请假；1管理员代请
     */
    @TableField(value = "leave_resource")
    private Integer leaveResource;
    /**
     * 创建部门
     */
    private Long createDept;

    /**
     * 创建者
     */
    private Long createBy;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新者
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Long updateBy;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;


    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}
