package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import org.dromara.common.mybatis.core.domain.BaseEntity;

import java.io.Serializable;

/**
 * @TableName zjk_sms_info
 */
@TableName(value = "zjk_sms_info")
@Data
public class ZjkSmsInfo extends BaseEntity implements Serializable {
    /**
     * 租户号
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 发送状态;0：未发送；1已发送
     */
    @TableField(value = "send_status")
    private Integer sendStatus;

    /**
     * 模板id
     */
    @TableField(value = "template_id")
    private String templateId;

    /**
     * 短信内容
     */
    @TableField(value = "sms_content")
    private String smsContent;

    /**
     * 重发次数
     */
    @TableField(value = "send_num")
    private Integer sendNum;

    /**
     * 发送后返回的resultId
     */
    @TableField(value = "status_id")
    private String statusId;

    /**
     * 发送返回的报文
     */
    @TableField(value = "return_msg")
    private String returnMsg;

    /**
     * 发送返回的状态码
     */
    @TableField(value = "return_code")
    private String returnCode;

    /**
     * 发送批次
     */
    @TableField(value = "batch_num")
    private String batchNum;

    /**
     * 批次类型;（1：群发；0单发）
     */
    @TableField(value = "batch_type")
    private Integer batchType;

    /**
     * 接收人用户id
     */
    @TableField(value = "receive_user_id")
    private Long receiveUserId;

    /**
     * 发送人用户id
     */
    @TableField(value = "send_by")
    private Long sendBy;
    /**
     * 模板渲染参数
     */
    @TableField(value = "param_json")
    private String paramJson;
    /**
     * 发送手机号
     */
    @TableField(value = "receive_phone")
    private String receivePhone;
    @TableField(exist = false)
    private static final long serialVersionUID = 1L;


}
