package org.dromara.zjk.domain.bo;

import org.dromara.zjk.domain.LearningEvaluate;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 【请填写功能名称】业务对象 zjk_learning_evaluate
 *
 * @author ygh
 * @date 2025-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = LearningEvaluate.class, reverseConvertGenerate = false)
public class LearningEvaluateBo extends BaseEntity {

    /**
     * 租户号
     */
    private String ID;

    /**
     * 课程id;zjk_learning_course主键
     */
    @NotNull(message = "课程id;zjk_learning_course主键不能为空", groups = {AddGroup.class, EditGroup.class})
    private Long courseId;

    /**
     * 难易程度
     */
    @NotNull(message = "难易程度不能为空", groups = {AddGroup.class, EditGroup.class})
    private Long diffLevel;

    /**
     * 掌握程度
     */
    @NotNull(message = "掌握程度不能为空", groups = {AddGroup.class, EditGroup.class})
    private Long getLevel;

    /**
     * 完成时间
     */
    @NotNull(message = "完成时间不能为空", groups = {AddGroup.class, EditGroup.class})
    private Date finishTime;

    /**
     * 学习心得
     */
    @NotBlank(message = "学习心得不能为空", groups = {AddGroup.class, EditGroup.class})
    private String remark;
    private String expertName;
    private String courseName;

}
