package org.dromara.zjk.domain.vo;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.domain.ZjkCreditReward;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 信用奖励视图对象 zjk_credit_reward
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkCreditReward.class)
public class ZjkCreditRewardVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 租户号
     */
    @ExcelProperty(value = "租户号")
    private String ID;

    /**
     * 信用奖励名称
     */
    @ExcelProperty(value = "信用奖励名称")
    private String rewardName;

    /**
     * 激励类型;字典值credit_reward_type
     */
    @ExcelProperty(value = "激励类型;字典值credit_reward_type")
    private Long rewardType;

    /**
     * 激励内容
     */
    @ExcelProperty(value = "激励内容")
    private String rewardContent;

    /**
     * 激励标的;字典值 信用
     */
    @ExcelProperty(value = "激励标的;字典值 信用")
    private Long rewardObj;

    /**
     * 生效符号;><=
     */
    @ExcelProperty(value = "生效符号;><=")
    private String effectFlag;

    /**
     * 生效标准;临界分值
     */
    @ExcelProperty(value = "生效标准;临界分值")
    private Long effectStandard;

    /**
     * 激励截至时间
     */
    @ExcelProperty(value = "激励截至时间")
    private Date rewardUntil;

    /**
     * 是否永久;1：永久；0不永久
     */
    @ExcelProperty(value = "是否永久;1：永久；0不永久")
    private Long isForever;

    /**
     * 启用标识
     */
    @ExcelProperty(value = "启用标识")
    private Long status;

    /**
     * 创建人
     */
    @ExcelProperty(value = "创建人")
    private Long createBy;

    /**
     * 创建时间
     */
    @ExcelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 更新人
     */
    @ExcelProperty(value = "更新人")
    private Long updateBy;

    /**
     * 更新时间
     */
    @ExcelProperty(value = "更新时间")
    private Date updateTime;

    /**/
    private Long personCount;


}
