package org.dromara.zjk.learning_world.domain.entity;

import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.tenant.core.TenantEntity;

import java.io.Serial;
import java.util.Date;

/**
 * 活动管理对象 zjk_learning_activity
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_learning_activity")
public class ZjkLearningActivity extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动分类
     */
    private String activityClassify;

    /**
     * 活动地点
     */
    private String activityAddress;

    /**
     * 活动数量
     */
    private Long activityNum;

    /**
     * 封面图
     */
    private String activityPic;

    /**
     * 活动内容
     */
    private String activityContent;

    /**
     * 是否发布
     */
    private String isPublic;

    /**
     * 状态
     */
    private String status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否删除
     */
    @TableLogic
    private Long delFlag;

    /**
     * 活动开始时间
     */
    private Date activityStartTime;
    /**
     * 活动结束时间
     */
    private Date activityEndTime;

    /**
     * 活动状态
     */
    private String activityStatus;

    /**
     * 上下架时间
     */
    private Date takedownTime;

    /**
     * 创建人
     */
    private Long userId;


}
