package org.dromara.zjk.learning_world.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningCourse;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;


/**
 * 课程视图对象 zjk_learning_course
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkLearningCourse.class)
public class ZjkLearningCourseVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 课程名称
     */
    private String courseName;

    /**
     * 课程分类
     */
    private String courseClassify;

    /**
     * 授课方式
     */
    private String teachingType;

    /**
     * 课程简介
     */
    private String courseBrief;

    /**
     * 课程图片
     */
    private String coursePic;

    /**
     * 状态
     */
    private String status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 附件
     */
    private String courseAttachment;

    @ExcelProperty(value = "用户名称")
    private String userName;
    /**
     * 上下架时间
     */
    private Date takedownTime;

    private Boolean recommended;

    private String performWorkId;

    /**
     * 附件 url
     */
    private String url;

    /**
     * 附件名称
     */
    private String originalName;
}
