package org.dromara.zjk.learning_world.service;

import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.zjk.learning_world.domain.bo.ZjkProblemBo;
import org.dromara.zjk.learning_world.domain.vo.ZjkProblemVo;

import java.util.Collection;
import java.util.List;

/**
 * 问题管理Service接口
 *
 * @author wt
 * @date 2024-11-20
 */
public interface IZjkProblemService {

    /**
     * 查询问题管理
     *
     * @param id 主键
     * @return 问题管理
     */
    ZjkProblemVo queryById(Long id);

    /**
     * 分页查询问题管理列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 问题管理分页列表
     */
    TableDataInfo<ZjkProblemVo> queryPageList(ZjkProblemBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的问题管理列表
     *
     * @param bo 查询条件
     * @return 问题管理列表
     */
    List<ZjkProblemVo> queryList(ZjkProblemBo bo);

    /**
     * 新增问题管理
     *
     * @param bo 问题管理
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkProblemBo bo);

    /**
     * 修改问题管理
     *
     * @param bo 问题管理
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkProblemBo bo);

    /**
     * 校验并批量删除问题管理信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    int reply(ZjkProblemBo bo);
}
