package org.dromara.zjk.statement.service;

import org.dromara.zjk.statement.domain.ZjkMoneyExpertStatement;
import org.dromara.zjk.statement.domain.vo.ZjkMoneyExpertStatementVo;
import org.dromara.zjk.statement.domain.bo.ZjkMoneyExpertStatementBo;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 专家费用报表Service接口
 *
 * @author ygh
 * @date 2024-12-16
 */
public interface IZjkMoneyExpertStatementService {

    /**
     * 查询专家费用报表
     *
     * @param id 主键
     * @return 专家费用报表
     */
    ZjkMoneyExpertStatementVo queryById(Long id);

    /**
     * 分页查询专家费用报表列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 专家费用报表分页列表
     */
    TableDataInfo<ZjkMoneyExpertStatementVo> queryPageList(ZjkMoneyExpertStatementBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的专家费用报表列表
     *
     * @param bo 查询条件
     * @return 专家费用报表列表
     */
    List<ZjkMoneyExpertStatementVo> queryList(ZjkMoneyExpertStatementBo bo);

    /**
     * 新增专家费用报表
     *
     * @param bo 专家费用报表
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkMoneyExpertStatementBo bo);

    /**
     * 修改专家费用报表
     *
     * @param bo 专家费用报表
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkMoneyExpertStatementBo bo);

    /**
     * 校验并批量删除专家费用报表信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
