/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.connector;

import com.tongweb.connector.Adapter;
import com.tongweb.connector.UpgradeProtocol;
import com.tongweb.connector.ajp.AjpNioProtocol;
import com.tongweb.connector.http11.Http11NioProtocol;
import com.tongweb.web.util.net.SSLHostConfig;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public interface ProtocolHandler {
    public Adapter getAdapter();

    public void setAdapter(Adapter var1);

    public Executor getExecutor();

    public void setExecutor(Executor var1);

    public ScheduledExecutorService getUtilityExecutor();

    public void setUtilityExecutor(ScheduledExecutorService var1);

    public void init() throws Exception;

    public void start() throws Exception;

    public void pause() throws Exception;

    public void resume() throws Exception;

    public void stop() throws Exception;

    public void destroy() throws Exception;

    public void closeServerSocketGraceful();

    public long awaitConnectionsClose(long var1);

    public boolean isSendfileSupported();

    public void addSslHostConfig(SSLHostConfig var1);

    public SSLHostConfig[] findSslHostConfigs();

    public void addUpgradeProtocol(UpgradeProtocol var1);

    public UpgradeProtocol[] findUpgradeProtocols();

    default public int getDesiredBufferSize() {
        return -1;
    }

    default public String getId() {
        return null;
    }

    public static ProtocolHandler create(String protocol) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (protocol == null || "HTTP/1.1".equals(protocol) || Http11NioProtocol.class.getName().equals(protocol)) {
            return new Http11NioProtocol();
        }
        if ("AJP/1.3".equals(protocol) || AjpNioProtocol.class.getName().equals(protocol)) {
            return new AjpNioProtocol();
        }
        Class<?> clazz = Class.forName(protocol);
        return (ProtocolHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

