/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.mbeans;

import com.tongweb.container.Group;
import com.tongweb.container.Role;
import com.tongweb.container.User;
import com.tongweb.container.mbeans.MBeanUtils;
import com.tongweb.web.util.modeler.BaseModelMBean;
import com.tongweb.web.util.modeler.ManagedBean;
import com.tongweb.web.util.modeler.Registry;
import com.tongweb.web.util.res.StringManager;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class GroupMBean
extends BaseModelMBean {
    private static final StringManager sm = StringManager.getManager(GroupMBean.class);
    protected final Registry registry = MBeanUtils.createRegistry();
    protected final ManagedBean managed = this.registry.findManagedBean("Group");

    public String[] getRoles() {
        Group group = (Group)this.resource;
        ArrayList<String> results = new ArrayList<String>();
        Iterator<Role> roles = group.getRoles();
        while (roles.hasNext()) {
            Role role = null;
            try {
                role = roles.next();
                ObjectName oname = MBeanUtils.createObjectName(this.managed.getDomain(), role);
                results.add(oname.toString());
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException(sm.getString("userMBean.createError.role", role), e);
            }
        }
        return results.toArray(new String[0]);
    }

    public String[] getUsers() {
        Group group = (Group)this.resource;
        ArrayList<String> results = new ArrayList<String>();
        Iterator<User> users = group.getUsers();
        while (users.hasNext()) {
            User user = null;
            try {
                user = users.next();
                ObjectName oname = MBeanUtils.createObjectName(this.managed.getDomain(), user);
                results.add(oname.toString());
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException(sm.getString("userMBean.createError.user", user), e);
            }
        }
        return results.toArray(new String[0]);
    }

    public void addRole(String rolename) {
        Group group = (Group)this.resource;
        if (group == null) {
            return;
        }
        Role role = group.getUserDatabase().findRole(rolename);
        if (role == null) {
            throw new IllegalArgumentException(sm.getString("userMBean.invalidRole", rolename));
        }
        group.addRole(role);
    }

    public void removeRole(String rolename) {
        Group group = (Group)this.resource;
        if (group == null) {
            return;
        }
        Role role = group.getUserDatabase().findRole(rolename);
        if (role == null) {
            throw new IllegalArgumentException(sm.getString("userMBean.invalidRole", rolename));
        }
        group.removeRole(role);
    }
}

