/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.buildutil;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class RepeatableArchive
extends Task {
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private String datetime;
    private String pattern;

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void execute() throws BuildException {
        Date date;
        SimpleDateFormat sdf = new SimpleDateFormat(this.pattern);
        try {
            date = sdf.parse(this.datetime);
        }
        catch (ParseException e) {
            throw new BuildException((Throwable)e);
        }
        byte[] buf = new byte[8192];
        FileTime lastModified = FileTime.fromMillis(date.getTime());
        for (FileSet fs : this.filesets) {
            String[] files;
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File basedir = ds.getBasedir();
            for (String file : files = ds.getIncludedFiles()) {
                File archive = new File(basedir, file);
                File oldArchive = new File(basedir, file + ".old");
                try {
                    Files.move(archive.toPath(), oldArchive.toPath(), StandardCopyOption.ATOMIC_MOVE);
                    try (ZipFile oldZipFile = new ZipFile(oldArchive);
                         ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(archive));){
                        Enumeration<? extends ZipEntry> oldEntries = oldZipFile.entries();
                        while (oldEntries.hasMoreElements()) {
                            int numRead;
                            ZipEntry oldEntry = oldEntries.nextElement();
                            ZipEntry entry = new ZipEntry(oldEntry.getName());
                            entry.setLastModifiedTime(lastModified);
                            zipOut.putNextEntry(entry);
                            InputStream is = oldZipFile.getInputStream(oldEntry);
                            while ((numRead = is.read(buf)) >= 0) {
                                zipOut.write(buf, 0, numRead);
                            }
                        }
                    }
                    if (!archive.setLastModified(lastModified.toMillis())) {
                        throw new BuildException("setLastModified failed for [" + archive.getAbsolutePath() + "]");
                    }
                    Files.delete(oldArchive.toPath());
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe);
                }
            }
        }
    }
}

