### 7. 错误处理与异常设计

#### 错误码规范
1. **全局错误码表**
    - 采用 [R.fail(code, message)](file://D:\jyh-zjk\ruoyi-common\ruoyi-common-core\src\main\java\org\dromara\common\core\domain\R.java#L78-L80) 统一返回错误（如 `auth.grant.type.error`）
    - 分类示例：
        - `4xx`：客户端错误（如无效租户、非法参数）
        - `5xx`：服务端错误（如远程调用超时、数据库异常）
    - 关键错误码：
        - `401`：未授权（`NotLoginException`）
        - `403`：禁止访问（如法人账号登录限制）
        - `500`：系统内部错误（兜底码）

#### 异常处理策略
1. **重试机制**
    - 远程服务调用（如 `DubboReference` 服务）配置超时重试（示例中 `timeout = 20000ms`）
    - 登录异步消息发送延迟重试（`scheduledExecutorService.schedule`）
2. **告警**
    - 日志标记 [ERROR](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\enums\PointTrendEnum.java#L17-L17) 级别（如 `log.error("山西政务回调异常")`）
    - 集成 [RemoteMessageService](file://D:\jyh-zjk\ruoyi-api\ruoyi-api-resource\src\main\java\org\dromara\resource\api\RemoteMessageService.java#L7-L23) 发送告警通知
3. **兜底逻辑**
    - 租户不存在时返回默认配置（参考 [tenantList](file://D:\jyh-zjk\ruoyi-auth\src\main\java\org\dromara\auth\controller\TokenController.java#L287-L331) 方法中的 [enable](file://D:\jyh-zjk\ruoyi-common\ruoyi-common-tenant\src\main\java\org\dromara\common\tenant\properties\TenantProperties.java#L19-L19) 检查）
    - 第三方登录失败时返回友好提示（如 [socialCallback](file://D:\jyh-zjk\ruoyi-auth\src\main\java\org\dromara\auth\controller\TokenController.java#L231-L244) 的 `response.ok()` 判断）

#### 日志与追踪
1. **TraceID串联**
    - 使用 `MDC` 或 `SaToken` 的 [LoginHelper.getUserId()](file://D:\jyh-zjk\ruoyi-common\ruoyi-common-satoken\src\main\java\org\dromara\common\satoken\utils\LoginHelper.java#L96-L98) 关联请求链路
    - 关键日志字段：
      ```java
      log.info("客户端id: {}, 认证类型: {}", clientId, grantType); // 业务日志
      log.error("登陆失败: {}", e.getMessage()); // 异常日志
      ```


---

### 8. 测试设计建议

#### 关键测试场景
1. **边界值**
    - 空 [clientId](file://D:\jyh-zjk\ruoyi-auth\src\main\java\org\dromara\auth\domain\vo\LoginVo.java#L40-L41)/[tenantId](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\ZjkLeave.java#L68-L69) 的登录请求（见 [userCenter](file://D:\jyh-zjk\ruoyi-auth\src\main\java\org\dromara\auth\controller\TokenController.java#L159-L194) 方法）
    - 并发登录限制（如 [RedisUtils](file://D:\jyh-zjk\ruoyi-common\ruoyi-common-redis\src\main\java\org\dromara\common\redis\utils\RedisUtils.java#L22-L547) 的 [loginUrl](file://D:\jyh-zjk\ruoyi-common\ruoyi-common-core\src\main\java\org\dromara\common\core\domain\model\LoginBody.java#L46-L46) 缓存竞争）
2. **并发场景**
    - 多租户同时登录（[tenantList](file://D:\jyh-zjk\ruoyi-auth\src\main\java\org\dromara\auth\controller\TokenController.java#L287-L331) 接口的租户筛选逻辑）
    - 第三方登录回调高并发（[socialCallback](file://D:\jyh-zjk\ruoyi-auth\src\main\java\org\dromara\auth\controller\TokenController.java#L231-L244) 的 `AuthResponse` 处理）

#### Mock方案
1. **外部依赖模拟**
    - 使用 `@DubboReference(stub = "true")` 模拟远程服务（如 [RemoteMessageService](file://D:\jyh-zjk\ruoyi-api\ruoyi-api-resource\src\main\java\org\dromara\resource\api\RemoteMessageService.java#L7-L23)）
    - 第三方登录 Mock 工具（如 [SocialUtils.loginAuth](file://D:\jyh-zjk\ruoyi-common\ruoyi-common-social\src\main\java\org\dromara\common\social\utils\SocialUtils.java#L24-L31) 返回模拟 `AuthUser`）

#### 性能测试用例
1. **压测模型**
    - 场景：`/login` 接口每秒 1000 次请求（检查 [RedisUtils](file://D:\jyh-zjk\ruoyi-common\ruoyi-common-redis\src\main\java\org\dromara\common\redis\utils\RedisUtils.java#L22-L547) 和 `Dubbo` 性能）
    - 指标：TP99 < 200ms，错误率 < 0.1%
    - 监控点：`ScheduledExecutorService` 的线程池队列堆积

---

### 9. 待解决问题与风险

#### 技术难点清单
1. **多租户隔离**
    - 风险：[tenantId](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\ZjkLeave.java#L68-L69) 传递遗漏（如 [userCenter](file://D:\jyh-zjk\ruoyi-auth\src\main\java\org\dromara\auth\controller\TokenController.java#L159-L194) 方法需显式校验）
    - 方案：AOP 统一拦截租户参数（参考 [TenantHelper.isEnable()](file://D:\jyh-zjk\ruoyi-common\ruoyi-common-tenant\src\main\java\org\dromara\common\tenant\helper\TenantHelper.java#L39-L41)）
2. **第三方登录集成**
    - 风险：[socialProperties](file://D:\jyh-zjk\ruoyi-auth\src\main\java\org\dromara\auth\controller\TokenController.java#L61-L61) 配置变更导致兼容性问题
    - 方案：配置热更新 + 版本化回滚

#### 依赖未就绪项
1. **政务平台对接**
    - 依赖：[SxzwfwLoginService](file://D:\jyh-zjk\ruoyi-auth\src\main\java\org\dromara\auth\service\SxzwfwLoginService.java#L6-L12) 的 `accessLink` 协议稳定性
    - 备选：本地模拟政务认证流程（[gotoSxzwfw](file://D:\jyh-zjk\ruoyi-auth\src\main\java\org\dromara\auth\controller\TokenController.java#L196-L200) 接口）

#### 备选方案评估
| 场景               | 主方案                     | 备选方案                     |
|--------------------|---------------------------|-----------------------------|
| Dubbo 服务超时     | 重试 2 次                 | 降级返回缓存数据            |
| 租户查询失败       | 返回空列表                | 强制跳转默认租户            |
| 消息发送失败       | 异步重试 3 次             | 记录本地 DB 待补偿          |

---
全局错误码表： | 错误码 | 含义 | 场景示例 | |--------|-----------------------|-----------------------------------| | 40001 | 权限不足 | SysUserController中@SaCheckPermission校验失败 | | 40002 | 租户名额不足 | SysUserController.add()中租户用户名额检查失败 | | 40003 | 账号/手机/邮箱重复 | SysUserController.add()/edit()中唯一性校验失败 | | 50001 | 第三方登录失败 | TokenController.socialCallback()中授权响应异常 | | 50002 | 客户端认证类型错误 | TokenController.login()中grantType校验失败 |