package org.dromara.zjk.annualInspection.annualInspectionAudit.domain;

import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.baomidou.mybatisplus.annotation.TableField;
import lombok.EqualsAndHashCode;
import org.dromara.common.tenant.core.TenantEntity;
import org.dromara.zjk.annotation.PropertyMsg;

import java.io.Serial;
import java.util.Date;

/**
 * 年检管理对象 zjk_annual_inspection
 *
 * @author zhangzhou
 * @date 2024-11-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_annual_inspection")
public class ZjkAnnualInspection extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @PropertyMsg(propertyName = "id")
    private Long id;

    /**
     * 用户 id
     */
    @PropertyMsg(propertyName = "user_id")
    private Long userId;

    /**
     * 专家 id
     */
    @PropertyMsg(propertyName = "expert_id")
    private Long expertId;

    /**
     * 年检编号
     */
    @PropertyMsg(propertyName = "annual_inspection_sn")
    private String annualInspectionSn;

    /**
     * 年检名称
     */
    @PropertyMsg(propertyName = "annual_inspection_name")
    private String annualInspectionName;

    /**
     * 审核方式(1 人工年检 2 自动年检)
     */
    @PropertyMsg(propertyName = "annual_inspection_type")
    private String annualInspectionType;

    /**
     * 年检状态(1 待年检 2 已通过 3 未通过)
     */
    @PropertyMsg(propertyName = "annual_inspection_status")
    private String annualInspectionStatus;

    /**
     * 审核时间
     */
    @PropertyMsg(propertyName = "audit_time")
    private Date auditTime;

    /**
     * 逻辑删除
     */
    @TableLogic
    @PropertyMsg(propertyName = "del_flag")
    private Long delFlag;

    /**
     * 审核原因
     */
    @PropertyMsg(propertyName = "审核原因")
    private String reason;

    private String hmac;
    /**
     * 更新人（年检审核人）
     */
    @TableField(exist = false)
    private String updateByStr;
}
