package org.dromara.zjk.config;

import com.alibaba.fastjson.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.dubbo.config.annotation.DubboReference;
import org.dromara.common.core.constant.HttpStatus;
import org.dromara.common.core.domain.R;
import org.dromara.common.core.utils.StringUtils;
import org.dromara.system.api.RemoteConfigService;
import org.dromara.zjk.utils.ApiThreadLocal;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

/**
 * @author : yanguohua
 * @version : 1.0
 * @date : 2025/8/26 15:19
 */
@Component
public class ApiAuthInterceptor implements HandlerInterceptor {

    @DubboReference
    private RemoteConfigService remoteConfigService;

    private static final String DEFAULT_SECRET_KEY = "k6psy7kafT%UaPd2";

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        // 设置响应的字符编码为 UTF-8
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json;charset=UTF-8");

        String authorizationCode = request.getHeader("Authorization");

        // 获取密钥配置
        String secretKey = remoteConfigService.selectConfigByKey("api.secret.key");

        // 验证授权码是否为空
        if (StringUtils.isEmpty(authorizationCode)) {
            response.setStatus(HttpStatus.UNAUTHORIZED);
            response.getWriter().write(JSON.toJSONString(R.fail("授权码为空，禁止访问")));
            return false;
        }

        // 验证授权码是否匹配
        if (!authorizationCode.equals(secretKey)) {
            response.setStatus(HttpStatus.FORBIDDEN);
            response.getWriter().write(JSON.toJSONString(R.fail("授权码错误，禁止访问")));
            return false;
        }
        ApiThreadLocal.putAk(authorizationCode);
        return true;
    }
}
