package org.dromara.zjk.config;

import cn.bubi.SDK;
import cn.bubi.model.request.*;
import cn.bubi.model.request.operation.AccountSetMetadataOperation;
import cn.bubi.model.request.operation.BaseOperation;
import cn.bubi.model.response.*;
import cn.bubi.model.response.result.data.Signature;
import cn.bubi.model.response.result.data.TransactionHistory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Slf4j
@Component
public class OnChainUtils {
    private static SDK sdk;
    @Resource
    private YsdpaasConfig ysdpaasConfig;

    // 在 OnChainUtils 中添加异步方法
    @Async
    public void toChainAsync(String data, Long reviewId) {
        toChain(data, reviewId);
    }


    //    private static String address = "adxSqD9EdNMNYkfssD28YmSmgE1NLdm18Uhi9";
//    private static String privateKey = "privbynqzw8xmhim7LuwsLbkr4GVzkwn6CasJdbYEhVbFgFEcTWJ9Khq";
    public void toChain(String data, Long reviewId) {
        long startTime = System.currentTimeMillis();
        try {
            log.info("开始上链操作，reviewId: {}", reviewId);
            sdk = SDK.getInstance(ysdpaasConfig.getOnchainUrl());
            Long nonce = getAccountNonce();
            String key = "expert_cq_" + reviewId;
            BaseOperation[] operations = buildOperations(ysdpaasConfig.getOnchainAddress(), key, data);

            String tranBlob = seralizeTransaction(nonce, operations);

            Signature[] signatures = signTransaction(tranBlob);

            String txHash = submitTransaction(tranBlob, signatures);
            long endTime = System.currentTimeMillis();
            log.info("交易已提交，txHash: {}, reviewId: {}, 耗时: {} ms", txHash, reviewId, endTime - startTime);

            // 立即返回，不再等待区块链确认
            // 移除了原来的轮询等待逻辑

        } catch (Exception e) {
            long endTime = System.currentTimeMillis();
            log.error("上链操作异常，reviewId: {}, 耗时: {} ms", reviewId, endTime - startTime, e);
        }

        log.info("上链请求已完成，reviewId: {}", reviewId);
    }


    public long getAccountNonce() {
        long nonce = 0;

        // Init request
        String accountAddress = ysdpaasConfig.getOnchainAddress();
        AccountGetNonceRequest request = new AccountGetNonceRequest();
        request.setAddress(accountAddress);

        // Call getNonce
        AccountGetNonceResponse response = sdk.getAccountService().getNonce(request);
        if (0 == response.getErrorCode()) {
            nonce = response.getResult().getNonce();
        } else {
            System.out.println("error: " + response.getErrorDesc());
        }
        return nonce;
    }

    public static BaseOperation[] buildOperations(String accountAddresss, String key, String value) {
        AccountSetMetadataOperation operation = new AccountSetMetadataOperation();
        operation.setSourceAddress(accountAddresss);
        operation.setKey(key);
        operation.setValue(value);
        BaseOperation[] operations = {operation};
        return operations;
    }

    public String seralizeTransaction(Long nonce, BaseOperation[] operations) {
        String transactionBlob = null;

        // The account address to issue token
        String senderAddress = ysdpaasConfig.getOnchainAddress();  // 创建方账户
        // The gasPrice is fixed at 1000L, the unit is UGas
        Long gasPrice = 1000L;
        // Set up the maximum cost 10000000 UGas
        Long feeLimit = 10000000L;
        // Nonce should add 1
        nonce += 1;

        // Build transaction  Blob
        TransactionBuildBlobRequest transactionBuildBlobRequest = new TransactionBuildBlobRequest();
        transactionBuildBlobRequest.setSourceAddress(senderAddress);
        transactionBuildBlobRequest.setNonce(nonce);
        transactionBuildBlobRequest.setFeeLimit(feeLimit);
        transactionBuildBlobRequest.setGasPrice(gasPrice);
        for (int i = 0; i < operations.length; i++) {
            transactionBuildBlobRequest.addOperation(operations[i]);
        }
        TransactionBuildBlobResponse transactionBuildBlobResponse = sdk.getTransactionService().buildBlob(transactionBuildBlobRequest);
        if (transactionBuildBlobResponse.getErrorCode() == 0) {
            transactionBlob = transactionBuildBlobResponse.getResult().getTransactionBlob();
        } else {
            System.out.println("error: " + transactionBuildBlobResponse.getErrorDesc());
        }
        return transactionBlob;
    }

    public Signature[] signTransaction(String transactionBlob) {
        Signature[] signatures = null;
        // The account private key to issue token
        String senderPrivateKey = ysdpaasConfig.getOnchainKey(); // [创建方账户私钥]

        // Sign transaction Blob
        TransactionSignRequest transactionSignRequest = new TransactionSignRequest();
        transactionSignRequest.setBlob(transactionBlob);
        transactionSignRequest.addPrivateKey(senderPrivateKey);
        TransactionSignResponse transactionSignResponse = sdk.getTransactionService().sign(transactionSignRequest);
        if (transactionSignResponse.getErrorCode() == 0) {
            signatures = transactionSignResponse.getResult().getSignatures();
        } else {
            System.out.println("error: " + transactionSignResponse.getErrorDesc());
        }
        return signatures;
    }

    public static String submitTransaction(String transactionBlob, Signature[] signatures) {
        String hash = null;

        // Submit transaction
        TransactionSubmitRequest transactionSubmitRequest = new TransactionSubmitRequest();
        transactionSubmitRequest.setTransactionBlob(transactionBlob);
        transactionSubmitRequest.setSignatures(signatures);
        TransactionSubmitResponse transactionSubmitResponse = sdk.getTransactionService().submit(transactionSubmitRequest);
        if (0 == transactionSubmitResponse.getErrorCode()) {
            hash = transactionSubmitResponse.getResult().getHash();
        } else {
            System.out.println("error: " + transactionSubmitResponse.getErrorDesc());
        }
        return hash;
    }

    public static TransactionHistory checkTransactionStatus(String txHash) {
        // Init request
        TransactionGetInfoRequest request = new TransactionGetInfoRequest();
        request.setHash(txHash);

        // Call getInfo
        TransactionGetInfoResponse response = sdk.getTransactionService().getInfo(request);
        int errorCode = response.getErrorCode();
        TransactionHistory transactionHistory = null;
        if (errorCode == 0) {
            transactionHistory = response.getResult().getTransactions()[0];
        }

        return transactionHistory;
    }
}
