package org.dromara.zjk.controller;

import cn.dev33.satoken.annotation.SaCheckRole;
import cn.dev33.satoken.annotation.SaMode;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import lombok.RequiredArgsConstructor;
import org.dromara.common.core.constant.TenantConstants;
import org.dromara.common.excel.utils.ExcelUtil;
import org.dromara.common.log.annotation.Log;
import org.dromara.common.log.enums.BusinessType;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.web.core.BaseController;
import org.dromara.zjk.domain.dto.FpReportInQueryDTO;
import org.dromara.zjk.domain.vo.FpReportInVO;
import org.dromara.zjk.domain.vo.ZjkInvoiceReportVO;
import org.dromara.zjk.service.IZjkInvoiceService;
import org.dromara.zjk.service.ZjkInvoiceReportService;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 发票发票报表管理
 *
 * @author ygh
 * @date 2024-12-09
 */
@Validated
@RequiredArgsConstructor
@RestController
@RequestMapping("/invReport")
public class ZjkInvoiceReportController extends BaseController {
    private final IZjkInvoiceService zjkInvoiceService;
    private final ZjkInvoiceReportService zjkInvoiceReportService;


    /**
     * 查询发票报表列表
     */
    @SaCheckRole(value = {
        TenantConstants.JG_ROLE_KEY,
    }, mode = SaMode.OR)
    @GetMapping("/list")
    public TableDataInfo<ZjkInvoiceReportVO> list(ZjkInvoiceReportVO bo, PageQuery pageQuery) {
        return zjkInvoiceReportService.queryPageList(bo, pageQuery);
    }

    /**
     * 获取报表详细列表
     *
     * @param id 主键
     */
    @SaCheckRole(value = {
        TenantConstants.JG_ROLE_KEY,
    }, mode = SaMode.OR)
    @GetMapping("/{id}")
    public TableDataInfo<FpReportInVO> getInfoList(@NotNull(message = "主键不能为空")
                                                   @PathVariable Long id, PageQuery pageQuery, FpReportInQueryDTO dto) {
        dto.setId(id);
        return zjkInvoiceReportService.getInfoList(pageQuery, dto);
    }

    /**
     * 导出报表详细列表
     */
    @Log(title = "导出", businessType = BusinessType.EXPORT)
    @SaCheckRole(value = {
        TenantConstants.JG_ROLE_KEY,
    }, mode = SaMode.OR)
    @PostMapping("/export")
    public void export(FpReportInQueryDTO dto, HttpServletResponse response) {
        List<FpReportInVO> list = zjkInvoiceReportService.queryList(dto);
        ExcelUtil.exportExcel(list, "导出", FpReportInVO.class, response);
    }

}
