package org.dromara.zjk.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;

/**
 * 审批流程记录对象 zjk_approval_process_logs
 *
 * @author zhangzhou
 * @date 2024-11-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_approval_process_logs")
public class ZjkApprovalProcessLogs extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 操作项
     */
    private String actionItem;

    /**
     * 操作内容
     */
    private String actionContent;
    /**
     * 操作人
     */
    @TableField(exist = false)
    private String createByStr;
    /**
     * 审批意见
     */
    private String approvalOpinions;

    /**
     * 逻辑删除
     */
    @TableLogic
    private Long delFlag;


}
