package org.dromara.zjk.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;

import java.util.Date;

import java.io.Serial;

/**
 * 入库记录对象 zjk_expert_log
 *
 * @author zhangzhou
 * @date 2024-10-31
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_expert_log")
public class ZjkExpertLog extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号
     */
    @EncryptSensitive
    private String contactInfo;

    /**
     * 工作单位
     */
    private String organization;

    /**
     * 职务
     */
    private String position;

    /**
     * 入库结果
     */
    private Integer entryResult;

    /**
     * 申请时间
     */
    private Date applicationTime;

    /**
     * 驳回理由
     */
    private String rejectionReason;



    private Long expertId;

}
