package org.dromara.zjk.domain;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.baomidou.mybatisplus.annotation.TableField;
import com.alibaba.excel.annotation.ExcelIgnore;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.zjk.annotation.PropertyMsg;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;

import java.io.Serial;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 发票对象 zjk_invoice
 *
 * @author mzx
 * @date 2024-12-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_invoice")
@ExcelIgnoreUnannotated
public class ZjkInvoice extends BaseEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 发票表id
     */
    @PropertyMsg(propertyName = "id")
    @TableId(type = IdType.ASSIGN_ID)
    @ExcelIgnore // 忽略该字段导出
    private Long id;

    /**
     * 发票号码
     */
    @PropertyMsg(propertyName = "invoice_number")
    @ExcelProperty(value = "*发票号码")
    @NotBlank(message = "发票号码不能为空")
    private String invoiceNumber;

    /**
     * 发票金额
     */
    @PropertyMsg(propertyName = "invoice_money")
    @ExcelProperty(value = "*发票金额")
    @JsonFormat(shape = JsonFormat.Shape.NUMBER)
    @NotNull(message = "发票金额不能为空")
    private BigDecimal invoiceMoney;

    /**
     * 开票日期
     */
    @PropertyMsg(propertyName = "start_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(value = "yyyy-MM-dd")
    @ExcelProperty(value = "*开票日期")
    @NotNull(message = "开票日期不能为空")
    private Date startDate;

    @TableField(exist = false)
    @ExcelProperty(value = "*项目名称")
    @NotBlank(message = "项目名称不能为空")
    private String productName;
    /**
     * 项目阶段
     */
    @PropertyMsg(propertyName = "review_sn")
    @ExcelIgnore // 忽略该字段导出
    private Integer reviewSn;
    /**
     * 项目阶段
     */
    @ExcelProperty(value = "*项目阶段",converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "item_stage")
    @TableField(exist = false)
    @NotBlank(message = "项目阶段不能为空")
    private String reviewSnStr;
    /**
     * 专家名称
     */
    @PropertyMsg(propertyName = "expert_name")
    @ExcelProperty(value = "*专家名称")
    @NotBlank(message = "专家名称不能为空")
    private String expertName;

    /**
     * 专家身份证号
     */
    @PropertyMsg(propertyName = "expert_id_number")
    @ExcelProperty(value = "*专家身份证号")
    @NotBlank(message = "专家身份证号不能为空")
    private String expertIdNumber;

    /**
     * 联系电话
     */
    @EncryptSensitive
    @PropertyMsg(propertyName = "expert_phone")
    @ExcelProperty(value = "联系电话")
    private String expertPhone;


    /**
     * 职称等级
     */
    @PropertyMsg(propertyName = "expert_title_level")
    @ExcelProperty(value = "职称等级")
    private String expertTitleLevel;

    /**
     * 电子发票附件相关 ,存储oss的id
     */
    @PropertyMsg(propertyName = "invoice_attached")
    @ExcelIgnore // 忽略该字段导出
    private String invoiceAttached;
    /**
     * 项目id
     */
    @PropertyMsg(propertyName = "product_id")
    @ExcelIgnore // 忽略该字段导出
    private Long productId;

    /**
     * 结算单id
     */
    @PropertyMsg(propertyName = "settle_id")
    @ExcelIgnore // 忽略该字段导出
    private Long settleId;

    @TableField(exist = false)
    @ExcelProperty(value = "*结算单号")
    @NotBlank(message = "结算单号不能为空")
    private String settleNo;
    @ExcelIgnore // 忽略该字段导出
    private String hmac;
    /**
     * 审核状态1：已审核
     */
    @ExcelIgnore // 忽略该字段导出
    private Integer checkStatus;
}
