package org.dromara.zjk.domain.bo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.github.linpeilie.annotations.AutoMapper;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import org.dromara.common.excel.convert.MultiDictConvert;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.zjk.annotation.PropertyMsg;
import org.dromara.zjk.domain.ZjkExpert;
import org.dromara.zjk.domain.ZjkExpertMajor;
import org.dromara.zjk.domain.ZjkExpertProfessional;
import org.dromara.zjk.expert.expertAwards.domain.ZjkExpertAwards;
import org.dromara.zjk.expert.expertPaper.domain.ZjkExpertPaper;
import org.dromara.zjk.expert.expertPatent.domain.ZjkExpertPatent;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * expert业务对象 zjk_expert
 *
 * @author wangtong
 * @date 2024-10-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkExpert.class, reverseConvertGenerate = false)
public class ZjkExpertBo extends BaseEntity {

    /**
     * id
     */
    private Long expertId;

    /**
     * 姓名
     */
    @ExcelProperty(value = "*姓名")
    @Size(max = 20, message = "推荐专家姓名长度不能超过20个字符", groups = {AddGroup.class})
    @NotBlank(message = "姓名不能为空")
    private String expertName;

    /**
     * 性别
     */
    @ExcelProperty(value = "性别", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "sys_user_sex")
    @NotNull(message = "性别不能为空")
    private Long sex;

    /**
     * 身份证号
     */
    @ExcelProperty(value = "*身份证号")
    @Pattern(
        regexp = "^[1-9]\\d{5}(18|19|20|21)?\\d{2}(0[1-9]|1[0-2])(0[1-9]|[12]\\d|3[01])\\d{3}[0-9Xx]$",
        message = "身份证号格式不正确",
        groups = {AddGroup.class}
    )
    @EncryptSensitive
    @NotBlank(message = "身份证号不能为空")
    private String idCard;
    /**
     * 联系方式
     */
    @ExcelProperty(value = "*联系方式")
    @Size(max = 11, message = "专家手机号长度不能超过11个字符", groups = {AddGroup.class})
    @EncryptSensitive
    @NotBlank(message = "联系方式不能为空")
    private String contact;
    /**
     * 生日
     */
    @ExcelProperty(value = "生日")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date birthDate;



    /**
     * 工作单位
     */
    @ExcelProperty(value = "工作单位")
    private String workUnit;

    /**
     * 单位类型   1企业，2高校，3政府单位
     */
    @ExcelProperty(value = "单位类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "unit_type")
    private String unitType;


    /**
     * 是否专家推荐 1 是 2 否
     */
    @ExcelProperty(value = "是否专家推荐", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "is_recommend")
    private Integer isRecommend;

    /**
     * 职务
     */
    @ExcelProperty(value = "职务")
    private String duty;

    /**
     * 政治面貌
     */
    @ExcelProperty(value = "政治面貌", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "politics")
    private String politics;

    /**
     * 毕业学校
     */
    @ExcelProperty(value = "毕业学校")
    private String graduateSchool;

    /**
     * 专业
     */
    @ExcelProperty(value = "专业")
    private String major;


    @ExcelProperty(value = "学历", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "degree_type")
    private String degree;

    /**
     * 邮箱
     */
    @ExcelProperty(value = "邮箱")
    @EncryptSensitive
    private String email;

    /**
     * 专业技术资格
     */
    private String professional;

    /**
     * 专业技术资格取得时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date professionalAcquisitionDate;

    /**
     * 从事专业
     */
    @ExcelProperty(value = "从事专业")
    private String workProfessial;

    /**
     * 从事专业年限
     */
    @ExcelProperty(value = "从事专业年限", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "work_professial_year")
    private Integer workProfessialYear;

    /**
     * 照片
     */
    private String photograph;

    /**
     * 从事工作或研究领域
     */
    @ExcelProperty(value = "从事工作或研究领域", converter = MultiDictConvert.class)
    @ExcelDictFormat(dictType = "perform_work_type")
    private String performWorkId;

    /**
     * 其他领域描述
     */
    private String otherDescribe;

    /**
     * 主要工作经历
     */
    @ExcelProperty(value = "主要工作经历")
    private String workExperience;

    /**
     * 社会兼职情况
     */
    @ExcelProperty(value = "社会兼职情况")
    private String workPluralistic;

    /**
     * 主要论著、业绩成果及获奖情况
     */
    private String achievement;


    /**
     * 专家来源 1 省内 2 省外
     */
    @ExcelProperty(value = "专家来源", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "expert_sources")
    private String expertSources;

    /**
     * 论文
     */
//    @ExcelProperty(value = "论文")
    private String paperpath;

    /**
     * 专利
     */
//    @ExcelProperty(value = "专利")
    private String patentpath;

    /**
     * 备注
     */
//    @ExcelProperty(value = "备注")
    private String remark;

    /**
     * 是否删除
     */
    private Long deleteFlag;

    /**
     * 是否启用
     */
    private Integer useFlag;

    /**
     * 状态: 0：暂存 1：待审批 2：正常  3：拒绝 4 离职 5退休
     */
    private Integer status;

    /**
     * 是否为模板下载
     */
    private Integer isTemplate;

    /**
     * 审批类型  0 专家申请    1信息变更
     */
    private Integer approvalType;

    /**
     * 审批状态 0 不同意 1同意
     */
    private Integer approvalStatus;

    /**
     * 登录用户id
     */
    private Long userId;

    /**
     * 省
     */
    @ExcelProperty(value = "省")
    private String province;

    /**
     * 市
     */
    @ExcelProperty(value = "市")
    private String city;

    /**
     * 区
     */
    @ExcelProperty(value = "区")
    private String area;

    /**
     * 详细地址
     */
    @ExcelProperty(value = "详细地址")
    private String address;


    /**
     * 专业关系表对象
     */
    private List<ZjkExpertMajor> majorList;

    /*
    专家库技术资格关系表对象
     */
    private List<ZjkExpertProfessional> professionalList;

    /*
    获奖情况
     */
    private List<ZjkExpertAwards> zjkExpertAwardsList;

    /*
    论文信息
     */
    private List<ZjkExpertPaper> zjkExpertPaperList;

    /*
    专利信息
     */
    private List<ZjkExpertPatent> zjkExpertPatentList;

    /**
     * 审批时间
     */
    private Date approvalTime;

    /**
     * 其他附件
     */
    private String otherPath;

    /**
     * 离职退休息时间
     */
    private Date retirementTime;


    /**
     * 职称等级
     */
    @PropertyMsg(propertyName = "职称等级")
    private Long positionTitleLevel;
    @ExcelProperty(value = "职称等级")
    private String positionTitleLevelStr;

    @PropertyMsg(propertyName = "籍贯")
    @ExcelProperty(value = "籍贯")
    private String origin;

    private String unitTypeDescribe;

    private String expertIds;
    /**
     * 审批局同步过来的专业领域对应的类型名称
     */
    private String professorDeclareCategory;
    /**
     * 活动范围
     */
    private String scopeOfActivity;
    /**
     * 是否涉密0:不涉密  1：涉密
     */
    private Integer isClassified;

}
