package org.dromara.zjk.domain.bo;


import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import java.math.BigDecimal;
import java.util.Date;

import org.dromara.zjk.annotation.PropertyMsg;
import org.dromara.zjk.domain.ZjkInvoice;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 发票业务对象 zjk_invoice
 *
 * @author mzx
 * @date 2024-12-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkInvoice.class, reverseConvertGenerate = false)
public class ZjkInvoiceBo extends BaseEntity {

    /**
     * 发票表id
     */
    @NotNull(message = "发票表id不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 发票号码
     */
    @NotNull(message = "发票号码不能为空", groups = { AddGroup.class, EditGroup.class })
    @JsonFormat(shape = JsonFormat.Shape.NUMBER)
    private String invoiceNumber;

    /**
     * 发票金额
     */
    @NotNull(message = "发票金额不能为空", groups = { AddGroup.class, EditGroup.class })
    private BigDecimal invoiceMoney;

    /**
     * 开票日期
     */
    @NotNull(message = "开票日期不能为空", groups = { AddGroup.class, EditGroup.class })
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 专家名称
     */
    @NotBlank(message = "专家名称不能为空", groups = { AddGroup.class, EditGroup.class })
    private String expertName;

    /**
     * 联系电话
     */
    @EncryptSensitive
    @NotBlank(message = "联系电话不能为空", groups = { AddGroup.class, EditGroup.class })
    private String expertPhone;

    /**
     * 专家身份证号
     */
    @EncryptSensitive
    @NotBlank(message = "专家身份证号不能为空", groups = { AddGroup.class, EditGroup.class })
    private String expertIdNumber;

    /**
     * 专家职称等级
     */
    @NotBlank(message = "职称不能为空", groups = { AddGroup.class, EditGroup.class })
    private String expertTitleLevel;

    /**
     * 电子发票相关  对应ossid
     */
    @NotBlank(message = "电子发票附件 id不能为空", groups = { AddGroup.class, EditGroup.class })
    private String invoiceAttached;
    /**
     * 项目id
     */
    private Long productId;
    /**
     * 项目阶段
     */
    private Integer reviewSn;
    /**
     * 结算单id
     */
    private Long settleId;
    /**
     * 审核状态1：已审核
     */
    private Integer checkStatus;


}
