package org.dromara.zjk.domain.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.domain.ZjkProductSummarize;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 项目总结业务对象 zjk_product_summarize
 *
 * @author ygh
 * @date 2024-11-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkProductSummarize.class, reverseConvertGenerate = false)
public class ZjkProductSummarizeBo extends BaseEntity {

    /**
     * $column.columnComment
     */
    @NotNull(message = "$column.columnComment不能为空", groups = {EditGroup.class })
    private Long id;

    private String search;
    private String reviewSn;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date endTime;


    /**
     * $column.columnComment
     */
    private Long reviewId;

    /**
     * $column.columnComment
     */
    @NotBlank(message = "$column.columnComment不能为空", groups = { AddGroup.class})
    private String productSummarizeName;

    /**
     * $column.columnComment
     */
    @NotBlank(message = "项目总结分类不能为空", groups = { AddGroup.class })
    private String productSummarizeType;

    /**
     * $column.columnComment
     */
    @NotBlank(message = "项目概况不能为空", groups = { AddGroup.class })
    private String productGeneral;

    /**
     * $column.columnComment
     */
    @NotBlank(message = "审批范围不能为空", groups = { AddGroup.class})
    private String reviewScope;

    /**
     * $column.columnComment
     */
    @NotBlank(message = "审批结论不能为空", groups = { AddGroup.class})
    private String reviewConclusion;

    /**
     * $column.columnComment
     */
    @NotBlank(message = "反馈不能为空", groups = { AddGroup.class})
    private String feedback;

    /**
     * $column.columnComment
     */
    @NotBlank(message = "后续改进措施不能为空", groups = { AddGroup.class})
    private String subsequent;

    /**
     * $column.columnComment
     */
    @NotBlank(message = "附件不能为空", groups = { AddGroup.class})
    private String attachment;

    /**
     * $column.columnComment
     */
    private String expertIds;

    /**
     * $column.columnComment
     */
    @NotNull(message = "状态不能为空", groups = { AddGroup.class})
    private String status;

    /**
     * $column.columnComment
     */
    private String remark;

    private Long productId;


    private List<String> statusList;

    private List<Long> productIds;
    private List<Long> ids;
}
