package org.dromara.zjk.domain.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;


/**
 * 项目评审 BO 层
 *
 * @author ygh
 * @date 2024-10-29
 */
@Data
public class ZjkReviewProductBo  implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    private String search;

    private String reviewSn;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    private Long expertId;
    private Long userId;
    private Integer isExpert;
}
